###############################################################################
# OpenVAS Vulnerability Test
# $Id: phpbb_cve_2008_6506.nasl 2943 2009-03-29 15:14:47Z mime $
#
# phpBB Account Re-Activation Authentication Bypass Vulnerability
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Michael Meyer
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################


if (description)
{
 script_id(100086);
 script_bugtraq_id(32842);
 script_cve_id("CVE-2008-6506");
 script_version ("1.0");

 script_name(english:"phpBB Account Re-Activation Authentication Bypass Vulnerability");
 desc["english"] = "

 Overview:
  According to its version number, the remote version of phpbb
  is prone to an authentication-bypass vulnerability because it fails
  to properly enforce privilege requirements on some operations.

  Attackers can exploit this vulnerability to gain unauthorized access
  to the affected application, which may aid in further attacks.

  Versions prior to phpBB 3.0.4 are vulnerable. 

 See also;
  http://www.securityfocus.com/bid/32842
  http://www.phpbb.com/

 Solution:
  Updates are available; please see http://www.phpbb.com/.

 Risk factor : Medium";

 script_description(english:desc["english"]);
 script_summary(english:"Determine if phpbb is < 3.0.4");
 script_category(ACT_GATHER_INFO);
 script_family(english:"Web application abuses");
 script_copyright(english:"This script is Copyright (C) 2009 Michael Meyer");
 script_dependencies("phpbb_detect.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

include("global_settings.inc");
include("http_func.inc");
include("version_func.inc");

port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);
if (!can_host_php(port:port)) exit(0);

install = get_kb_item(string("www/", port, "/phpBB"));
if (isnull(install)) exit(0);

matches = eregmatch(string:install, pattern:"^(.+) under (/.*)$");
if (!isnull(matches)) {
	version = matches[1];
        if (version_is_less(version:version, test_version:"3.0.4") ) {
	   security_warning(port);
	   exit(0);
	}
}
