###############################################################################
# OpenVAS Vulnerability Test
# $Id: oscommerce_34348.nasl 3095 2009-04-10 17:06:18Z mime $
#
# osCommerce 'oscid' Session Fixation Vulnerability
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Michael Meyer
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100099);
 script_bugtraq_id(34348);
 script_version ("1.0");

 script_name(english:"osCommerce 'oscid' Session Fixation Vulnerability");
 desc["english"] = "

 Overview:
  osCommerce is prone to a session-fixation vulnerability.

  Attackers can exploit this issue to hijack a user's session and gain
  unauthorized access to the affected application.

  The following are vulnerable:

  osCommerce 2.2
  osCommerce 3.0 Beta

  Other versions may also be affected.

 See also:
  http://www.securityfocus.com/bid/34348

 Risk factor : Medium";

 script_description(english:desc["english"]);
 script_summary(english:"Determine if osCommerce is vulnerable to Session Fixation");
 script_category(ACT_GATHER_INFO);
 script_family(english:"Web application abuses");
 script_copyright(english:"This script is Copyright (C) 2009 Michael Meyer");
 script_dependencie("oscommerce_detect.nasl");
 script_require_keys("Software/osCommerce");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");

port = get_http_port(default:80);

if(!get_port_state(port))exit(0);
if(!can_host_php(port:port))exit(0);

if(!version = get_kb_item(string("www/", port, "/oscommerce")))exit(0);
if(!matches = eregmatch(string:version, pattern:"^(.+) under (/.*)$"))exit(0);

dir  = matches[2];

if(!isnull(dir))
{ 
 url = string(dir, "/index.php?osCsid=a815a815a815a815");
 req = http_get(item:url, port:port);
 buf = http_keepalive_send_recv(port:port, data:req, bodyonly:FALSE);
 if( buf == NULL )exit(0);
 if(egrep(pattern:"[a-zA-Z]+\.php\?osCsid=a815a815a815a815", string: buf) && !egrep(pattern:"Set-Cookie: osCsid=[a-zA-Z0-9]+" , string: buf) )
   {    
    security_warning(port:port);
    exit(0);
   }
}

exit(0);
