###############################################################################
# This script was written by David Maciejak <david dot maciejak at kyxar dot fr>
# based on work from
# (C) Tenable Network Security
#
# Ref: Jouko Pynnonen
#
# Date: 03/12/2009 Antu Sanadi <santu@secpod.com>
#
# This script is released under the GNU GPLv2
###############################################################################

if(description)
{
  script_id(14250);
  script_bugtraq_id(9089);
  script_version("$Revision: 2750 $");
  script_name(english:"Opera skin zip file buffer overflow vulnerability");
  desc["english"] = "
  The remote host is using Opera - an alternative web browser.
  This version is vulnerable to a security weakness.

  A problem has been identified in the handling of zipped skin
  files by Opera. Because of this, it may be possible for an attacker
  to gain unauthorized access to a system using the vulnerable browser.

  Solution : Install Opera 7.23 or newer.

  Risk factor : High";

  script_description(english:desc["english"]);
  script_summary(english:"Determines the version of Opera.exe");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"This script is Copyright (C) 2004 David Maciejak");
  script_family(english:"Windows");
  script_dependencies("secpod_opera_detection_win_900036.nasl");
  script_require_keys("Opera/Win/Version");
  exit(0);
}


include("version_func.inc");

OperaVer = get_kb_item("Opera/Win/Version");
if(!OperaVer){
  exit(0);
}

if(version_is_less_equal(version:OperaVer, test_version:"7.22")){
  security_hole(0);
}
