#
#
#
# This script was written by KK Liu
# [LSD] Critical security vulnerability in Microsoft Operating Systems
# Check methods based on Eeye's MSRPC scanner 1.03
#
# Updated 7/29/2003 - Now works for NT4
# Updated 8/13/2003 - Now works for Win 95/98/ME
#
#

if(description)
{
 script_id(11808);
 script_bugtraq_id(8205);
 script_cve_id("CAN-2003-0352");
 if(defined_func("script_xref"))script_xref(name:"IAVA", value:"2003-A-0011");
 script_version ("$Revision: 3399 $");

 name["english"] = "Microsoft RPC Interface Buffer Overrun (823980)";
 script_name(english:name["english"]);

 desc["english"] = "
 The remote host is running a version of Windows which has a flaw in
 its RPC interface which may allow an attacker to execute arbitrary code
 and gain SYSTEM privileges.  There is at least one Worm which is
 currently exploiting this vulnerability.  Namely, the MsBlaster worm.

 Solution: see
 http://www.microsoft.com/technet/security/bulletin/MS03-026.mspx
 http://www.microsoft.com/technet/security/bulletin/MS04-012.mspx
 http://www.microsoft.com/technet/security/bulletin/MS05-012.mspx
 http://www.microsoft.com/technet/security/bulletin/MS05-051.mspx
 http://www.microsoft.com/technet/security/bulletin/MS06-018.mspx

 Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "[LSD] Critical security vulnerability in Microsoft Operating Systems";
 script_summary(english:summary["english"]);

 script_category(ACT_ATTACK);

 script_copyright(english:"This script is Copyright (C) 2003 KK LIU");
 family["english"] = "Gain root remotely";
 script_family(english:family["english"]);
 script_dependencies("secpod_reg_enum.nasl", "msrpc_dcom2.nasl");
 script_require_ports("Services/msrpc", 135, 593);
 exit(0);
}


#
# The script code starts here
#

include("smb_nt.inc");
include("secpod_reg.inc");
include("secpod_smb_func.inc");

#if(!get_kb_item("Launched/11835"))exit(0);
#if(get_kb_item("SMB/KB824146"))exit(0);
#if(get_kb_item("SMB/KB824146_cant_be_verified"))exit(0);

if(hotfix_check_sp(xp:3, win2k:5, win2003:2) <= 0){
  exit(0);
}

# Check for update rollup
rollUp = registry_key_exists(key:"SOFTWARE\Microsoft\Updates\Windows 2000\SP5\Update Rollup 1");
if(rollUp){
  exit(0);
}

# Supersede checks (MS04-012, MS05-012, MS05-051 and MS06-018)
if(hotfix_missing(name:"828741") == 0 || hotfix_missing(name:"873333") == 0 ||
   hotfix_missing(name:"902400") == 0 || hotfix_missing(name:"913580") == 0){
  exit(0);
}

# Check for Hotfix 823980 (MS03-026)
if(hotfix_missing(name:"823980") == 1){
  security_hole(get_kb_item("SMB/transport"));
}
