###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for nagios-plugins vulnerability USN-532-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840037);
  script_version("$Revision: 1.0 $");
  script_xref(name: "USN", value: "532-1");
  script_cve_id("CVE-2007-5198");
  script_name(english: "Ubuntu Update for nagios-plugins vulnerability USN-532-1");
  desc["english"] = "

  Vulnerability Insight:

  Nobuhiro Ban discovered that check_http in nagios-plugins did
  not properly sanitize its input when following redirection
  requests. A malicious remote web server could cause a denial
  of service or possibly execute arbitrary code as the user.
  (CVE-2007-5198)
  
  Aravind Gottipati discovered that sslutils.c in nagios-plugins
  did not properly reset pointers to NULL. A malicious remote web
  server could cause a denial of service.
  
  Aravind Gottipati discovered that check_http in nagios-plugins
  did not properly calculate how much memory to reallocate when
  following redirection requests. A malicious remote web server
  could cause a denial of service.

  Affected Software/OS:
  nagios-plugins vulnerability on Ubuntu 6.06 LTS

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2007-October/000609.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of nagios-plugins vulnerability");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU6.06 LTS")
{

  if(isdpkgvuln(pkg:"nagios-plugins-basic", ver:"1.4.2-5ubuntu3.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"nagios-plugins-standard", ver:"1.4.2-5ubuntu3.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"nagios-plugins", ver:"1.4.2-5ubuntu3.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}