###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for ghostscript, gs-gpl vulnerability USN-501-2
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840110);
  script_version("$Revision: 1.0 $");
  script_xref(name: "USN", value: "501-2");
  script_cve_id("CVE-2007-2721");
  script_name(english: "Ubuntu Update for ghostscript, gs-gpl vulnerability USN-501-2");
  desc["english"] = "

  Vulnerability Insight:

  USN-501-1 fixed vulnerabilities in Jasper.  This update provides the
  corresponding update for the Jasper internal to Ghostscript.
  
  Original advisory details:
  
  It was discovered that Jasper did not correctly handle corrupted JPEG2000
  images. By tricking a user into opening a specially crafted JPG, a
  remote attacker could cause the application using libjasper to crash,
  resulting in a denial of service.

  Affected Software/OS:
  ghostscript, gs-gpl vulnerability on Ubuntu 6.10 ,
  Ubuntu 7.04 ,
  Ubuntu 7.10

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2007-October/000612.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of ghostscript, gs-gpl vulnerability");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU7.04")
{

  if(isdpkgvuln(pkg:"gs-gpl", ver:"8.54.dfsg.1-5ubuntu0.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"gs", ver:"8.54.dfsg.1-5ubuntu0.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU6.10")
{

  if(isdpkgvuln(pkg:"gs-gpl", ver:"8.50-1.1ubuntu1.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"gs", ver:"8.50-1.1ubuntu1.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU7.10")
{

  if(isdpkgvuln(pkg:"ghostscript-x", ver:"8.61.dfsg.1~svn8187-0ubuntu3.2", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"ghostscript", ver:"8.61.dfsg.1~svn8187-0ubuntu3.2", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libgs-dev", ver:"8.61.dfsg.1~svn8187-0ubuntu3.2", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libgs8", ver:"8.61.dfsg.1~svn8187-0ubuntu3.2", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"ghostscript-doc", ver:"8.61.dfsg.1~svn8187-0ubuntu3.2", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"gs-esp-x", ver:"8.61.dfsg.1~svn8187-0ubuntu3.2", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"gs-gpl", ver:"8.61.dfsg.1~svn8187-0ubuntu3.2", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"gs", ver:"8.61.dfsg.1~svn8187-0ubuntu3.2", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libgs-esp-dev", ver:"8.61.dfsg.1~svn8187-0ubuntu3.2", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"gs-aladdin", ver:"8.61.dfsg.1~svn8187-0ubuntu3.2", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"gs-common", ver:"8.61.dfsg.1~svn8187-0ubuntu3.2", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"gs-esp", ver:"8.61.dfsg.1~svn8187-0ubuntu3.2", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}