###############################################################################
# OpenVAS Vulnerability Test
#
# SuSE Update for krb5 SUSE-SA:2008:016
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(850051);
  script_version("$Revision: 1.0 $");
  script_xref(name: "SUSE-SA", value: "2008-016");
  script_cve_id("CVE-2008-0062", "CVE-2008-0063", "CVE-2008-0947", "CVE-2008-0948");
  script_name(english: "SuSE Update for krb5 SUSE-SA:2008:016");
  desc["english"] = "

  Vulnerability Insight:

  The krb5 package is the implementation of the Kerberos protocol suite
  from MIT.
  This update fixes three vulnerabilities, two of them are only possible if
  krb4 support is enabled:
  - CVE-2008-0062:   null/dangling pointer (krb4)
  - CVE-2008-0063:   operations on uninitialized buffer content,
  possible information leak (krb4)
  - CVE-2008-0947/8: out-of-bound array
  access in kadmind's RPC lib

  Impact:
  remote code execution

  Affected Software/OS:
  krb5 on SUSE LINUX 10.1, openSUSE 10.2, openSUSE 10.3, SUSE Linux Enterprise Desktop 10 SP1, SLE SDK 10 SP1, SUSE Linux Enterprise Server 10 SP1

  Fix: Please Install the Updated Packages.

  References:
  http://www.novell.com/linux/security/advisories/2008_16_krb5.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of krb5");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"SuSE Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "openSUSE10.3")
{

  if(isrpmvuln(pkg:"krb5", rpm:"krb5~1.6.2~22.4", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"krb5-apps-clients", rpm:"krb5-apps-clients~1.6.2~22.4", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"krb5-apps-servers", rpm:"krb5-apps-servers~1.6.2~22.4", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"krb5-client", rpm:"krb5-client~1.6.2~22.4", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"krb5-devel", rpm:"krb5-devel~1.6.2~22.4", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"krb5-server", rpm:"krb5-server~1.6.2~22.4", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"krb5-32bit", rpm:"krb5-32bit~1.6.2~22.4", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"krb5-devel-32bit", rpm:"krb5-devel-32bit~1.6.2~22.4", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "openSUSE10.2")
{

  if(isrpmvuln(pkg:"krb5", rpm:"krb5~1.5.1~23.14", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"krb5-apps-clients", rpm:"krb5-apps-clients~1.5.1~23.14", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"krb5-apps-servers", rpm:"krb5-apps-servers~1.5.1~23.14", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"krb5-client", rpm:"krb5-client~1.5.1~23.14", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"krb5-devel", rpm:"krb5-devel~1.5.1~23.14", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"krb5-server", rpm:"krb5-server~1.5.1~23.14", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"krb5-32bit", rpm:"krb5-32bit~1.5.1~23.14", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"krb5-devel-32bit", rpm:"krb5-devel-32bit~1.5.1~23.14", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SLESDK10SP1")
{

  if(isrpmvuln(pkg:"krb5-apps-clients", rpm:"krb5-apps-clients~1.4.3~19.30.6", rls:"SLESDK10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"krb5-apps-servers", rpm:"krb5-apps-servers~1.4.3~19.30.6", rls:"SLESDK10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"krb5-server", rpm:"krb5-server~1.4.3~19.30.6", rls:"SLESDK10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"krb5", rpm:"krb5~1.4.3~19.30.6", rls:"SLESDK10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"krb5-32bit", rpm:"krb5-32bit~1.4.3~19.30.6", rls:"SLESDK10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"krb5-client", rpm:"krb5-client~1.4.3~19.30.6", rls:"SLESDK10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"krb5-devel", rpm:"krb5-devel~1.4.3~19.30.6", rls:"SLESDK10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"krb5-devel-32bit", rpm:"krb5-devel-32bit~1.4.3~19.30.6", rls:"SLESDK10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "LES10SP1")
{

  if(isrpmvuln(pkg:"krb5-apps-clients", rpm:"krb5-apps-clients~1.4.3~19.30.6", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"krb5-apps-servers", rpm:"krb5-apps-servers~1.4.3~19.30.6", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"krb5-server", rpm:"krb5-server~1.4.3~19.30.6", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"krb5", rpm:"krb5~1.4.3~19.30.6", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"krb5-32bit", rpm:"krb5-32bit~1.4.3~19.30.6", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"krb5-client", rpm:"krb5-client~1.4.3~19.30.6", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"krb5-devel", rpm:"krb5-devel~1.4.3~19.30.6", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"krb5-devel-32bit", rpm:"krb5-devel-32bit~1.4.3~19.30.6", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SLESDk10SP1")
{

  if(isrpmvuln(pkg:"krb5-apps-clients", rpm:"krb5-apps-clients~1.4.3~19.30.6", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"krb5-apps-servers", rpm:"krb5-apps-servers~1.4.3~19.30.6", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"krb5-server", rpm:"krb5-server~1.4.3~19.30.6", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"krb5", rpm:"krb5~1.4.3~19.30.6", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"krb5-32bit", rpm:"krb5-32bit~1.4.3~19.30.6", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"krb5-client", rpm:"krb5-client~1.4.3~19.30.6", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"krb5-devel", rpm:"krb5-devel~1.4.3~19.30.6", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"krb5-devel-32bit", rpm:"krb5-devel-32bit~1.4.3~19.30.6", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SL10.1")
{

  if(isrpmvuln(pkg:"krb5", rpm:"krb5~1.4.3~19.30.6", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"krb5-apps-clients", rpm:"krb5-apps-clients~1.4.3~19.30.6", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"krb5-apps-servers", rpm:"krb5-apps-servers~1.4.3~19.30.6", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"krb5-client", rpm:"krb5-client~1.4.3~19.30.6", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"krb5-devel", rpm:"krb5-devel~1.4.3~19.30.6", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"krb5-server", rpm:"krb5-server~1.4.3~19.30.6", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}