###############################################################################
# OpenVAS Vulnerability Test
#
# SuSE Update for kernel SUSE-SA:2007:059
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(850104);
  script_version("$Revision: 1.0 $");
  script_xref(name: "SUSE-SA", value: "2007-059");
  script_cve_id("CVE-2006-6058", "CVE-2007-4997");
  script_name(english: "SuSE Update for kernel SUSE-SA:2007:059");
  desc["english"] = "

  Vulnerability Insight:

  The Linux kernel on openSUSE 10.3 was updated to fix a critical
  locking problem in the reiserfs code which lead to process deadlocks.

  This kernel update also fixes the following two security problems:

  - CVE-2006-6058: A local denial of service when mounting
  MINIX filesystems was fixed.

  - CVE-2007-4997: A 2 byte buffer underflow in the ieee80211 stack
  was fixed, which might be used by attackers in the
  local WLAN reach to crash the machine.

  and the following non security bugs:

  -  Kernel update to 2.6.22.12
  including fixes for:
  genirq, x86_64, Infiniband, networking, hwmon, device removal bug
  [#332612]
  -  patches.drivers/alsa-hdsp-zero-division:
  hdsp - Fix zero division (mainline: 2.6.24-rc1)
  -  patches.drivers/libata-ata_piix-properly_terminate_DMI_system_list:
  Fix improperly terminated array
  -  patches.rt/patch-2.6.22.1-rt4.openSUSE:
  updated existing patch (RT only)
  -  patches.drivers/alsa-hda-robust-probe:
  hda-intel - Improve HD-audio codec probing robustness  [#172330]
  -  patches.drivers/alsa-hda-probe-blacklist:
  hda-intel - Add probe_mask blacklist  [#172330]
  -  patches.fixes/megaraid_mbox-dell-cerc-support:
  Dell CERC support for megaraid_mbox  [#267134]
  -  patches.suse/reiserfs-use-reiserfs_error.diff:
  updated existing patch  [#299604]
  -  patches.arch/acpi_gpe_suspend_cleanup-fix.patch:
  ACPI: Call acpi_enable_wakeup_device at power_off (updated)
  [#299882]
  -  patches.suse/ocfs2-15-fix-heartbeat-write.diff:
  Fix heartbeat block writing  [#300730]
  -  patches.suse/ocfs2-14-fix-notifier-hang.diff:
  Fix kernel hang during cluster initialization  [#300730]
  -  patches.arch/acpi_autoload_bay.patch:
  updated existing patch  [#302482]
  -  patches.suse/zc0301_not_claim_logitech_quickcamera.diff:
  stop the zc0301 driver from claiming the Logitech QuickCam
  [#307055]
  -  patches.fixes/aux-at_vector_size.patch:
  Fixed kernel auxv vector overflow in some binfmt_misc cases
  [#310037]
  -  patches.fixes/nfs-name-len-limit:
  NFS: Fix an Oops in encode_lookup()  [#325913]
  -  patches.arch/acpi_lid-resume.patch:
  ACPI: button: send initial lid state after add and resume
  [#326814]
  -  patches.fixes/remove-transparent-bridge-sizing:
  PCI: remove transparent bridge sizing  [#331027]
  -  patches.fi ... 

  Description truncated, for more information please check the Reference URL

  Impact:
  remote denial of service

  Affected Software/OS:
  kernel on openSUSE 10.3

  Fix: Please Install the Updated Packages.

  References:
  http://www.novell.com/linux/security/advisories/2007_59_kernel.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of kernel");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"SuSE Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "openSUSE10.3")
{

  if(isrpmvuln(pkg:"kernel-bigsmp", rpm:"kernel-bigsmp~2.6.22.12~0.1", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-debug", rpm:"kernel-debug~2.6.22.12~0.1", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-default", rpm:"kernel-default~2.6.22.12~0.1", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-source", rpm:"kernel-source~2.6.22.12~0.1", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-syms", rpm:"kernel-syms~2.6.22.12~0.1", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-xen", rpm:"kernel-xen~2.6.22.12~0.1", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-xenpae", rpm:"kernel-xenpae~2.6.22.12~0.1", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}