###############################################################################
# OpenVAS Vulnerability Test
#
# SuSE Update for bind, bind9 SUSE-SA:2007:047
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(850109);
  script_version("$Revision: 1.0 $");
  script_xref(name: "SUSE-SA", value: "2007-047");
  script_cve_id("CVE-2007-2926");
  script_name(english: "SuSE Update for bind, bind9 SUSE-SA:2007:047");
  desc["english"] = "

  Vulnerability Insight:

  Amit Klein found that the random number generator used by the BIND
  name server to compute DNS query IDs generates predictable values.
  Remote attackers could exploit this flaw to conduct DNS cache
  poisoning attacks CVE-2007-2926.

  Impact:
  DNS cache poisoning

  Affected Software/OS:
  bind, bind9 on SUSE LINUX 10.1, openSUSE 10.2, SuSE Linux Enterprise Server 8, SUSE SLES 9, Novell Linux Desktop 9, Open Enterprise Server, Novell Linux POS 9, SUSE Linux Enterprise Desktop 10 SP1, SLE SDK 10 SP1, SUSE Linux Enterprise Server 10 SP1

  Fix: Please Install the Updated Packages.

  References:
  http://www.novell.com/linux/security/advisories/2007_47_bind.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of bind, bind9");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"SuSE Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "openSUSE10.2")
{

  if(isrpmvuln(pkg:"bind", rpm:"bind~9.3.2~56.3", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-libs", rpm:"bind-libs~9.3.2~56.3", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-utils", rpm:"bind-utils~9.3.2~56.3", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-libs-32bit", rpm:"bind-libs-32bit~9.3.2~56.3", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SLESSr8")
{

  if(isrpmvuln(pkg:"bind9", rpm:"bind9~9.2.2~105", rls:"SLESSr8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind9-devel", rpm:"bind9-devel~9.2.2~105", rls:"SLESSr8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind9-utils", rpm:"bind9-utils~9.2.2~105", rls:"SLESSr8"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SLESDK10SP1")
{

  if(isrpmvuln(pkg:"bind", rpm:"bind~9.3.4~1.16", rls:"SLESDK10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-devel", rpm:"bind-devel~9.3.4~1.16", rls:"SLESDK10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-libs-32bit", rpm:"bind-libs-32bit~9.3.4~1.16", rls:"SLESDK10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-libs", rpm:"bind-libs~9.3.4~1.16", rls:"SLESDK10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-utils", rpm:"bind-utils~9.3.4~1.16", rls:"SLESDK10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "OES")
{

  if(isrpmvuln(pkg:"bind", rpm:"bind~9.2.3~76.34", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-devel", rpm:"bind-devel~9.2.3~76.34", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-utils", rpm:"bind-utils~9.2.3~76.34", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SLES9")
{

  if(isrpmvuln(pkg:"bind", rpm:"bind~9.2.3~76.34", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-devel", rpm:"bind-devel~9.2.3~76.34", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-utils", rpm:"bind-utils~9.2.3~76.34", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "LES10SP1")
{

  if(isrpmvuln(pkg:"bind", rpm:"bind~9.3.4~1.16", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-devel", rpm:"bind-devel~9.3.4~1.16", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-libs-32bit", rpm:"bind-libs-32bit~9.3.4~1.16", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-libs", rpm:"bind-libs~9.3.4~1.16", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-utils", rpm:"bind-utils~9.3.4~1.16", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "NLDk9")
{

  if(isrpmvuln(pkg:"bind", rpm:"bind~9.2.3~76.34", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-devel", rpm:"bind-devel~9.2.3~76.34", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-utils", rpm:"bind-utils~9.2.3~76.34", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SLESDk10SP1")
{

  if(isrpmvuln(pkg:"bind", rpm:"bind~9.3.4~1.16", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-devel", rpm:"bind-devel~9.3.4~1.16", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-libs-32bit", rpm:"bind-libs-32bit~9.3.4~1.16", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-libs", rpm:"bind-libs~9.3.4~1.16", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-utils", rpm:"bind-utils~9.3.4~1.16", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SL10.1")
{

  if(isrpmvuln(pkg:"bind", rpm:"bind~9.3.2~17.18", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-libs", rpm:"bind-libs~9.3.2~17.18", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-utils", rpm:"bind-utils~9.3.2~17.18", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "NLPOS9")
{

  if(isrpmvuln(pkg:"bind", rpm:"bind~9.2.3~76.34", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-devel", rpm:"bind-devel~9.2.3~76.34", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-utils", rpm:"bind-utils~9.2.3~76.34", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}