###############################################################################
# OpenVAS Vulnerability Test
#
# SuSE Update for freetype2 SUSE-SA:2007:041
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(850084);
  script_version("$Revision: 1.0 $");
  script_xref(name: "SUSE-SA", value: "2007-041");
  script_cve_id("CVE-2007-2754");
  script_name(english: "SuSE Update for freetype2 SUSE-SA:2007:041");
  desc["english"] = "

  Vulnerability Insight:

  The TTF rendering library freetype2 was updated to fix an integer
  signedness bug when handling TTF images.

  This bug can lead to a heap overflow that can be exploited to execute
  arbitrary code. CVE-2007-2754

  Updates for SLE 10 Service Pack 1 and SUSE Linux 10.1 were released on
  Monday the 2nd of July, all other products received them at June 20th.

  Impact:
  remote code execution

  Affected Software/OS:
  freetype2 on SUSE LINUX 10.1, openSUSE 10.2, SuSE Linux Enterprise Server 8, SUSE SLES 9, Novell Linux Desktop 9, Open Enterprise Server, Novell Linux POS 9, SUSE Linux Enterprise Desktop 10 SP1, SUSE Linux Enterprise Server 10 SP1

  Fix: Please Install the Updated Packages.

  References:
  http://www.novell.com/linux/security/advisories/2007_41_freetype2.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of freetype2");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"SuSE Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "openSUSE10.2")
{

  if(isrpmvuln(pkg:"freetype2", rpm:"freetype2~2.2.1.20061027~15", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"freetype2-devel", rpm:"freetype2-devel~2.2.1.20061027~15", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"freetype2-32bit", rpm:"freetype2-32bit~2.2.1.20061027~15", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"freetype2-devel-32bit", rpm:"freetype2-devel-32bit~2.2.1.20061027~15", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SLESSr8")
{

  if(isrpmvuln(pkg:"freetype2", rpm:"freetype2~2.1.7~53.17", rls:"SLESSr8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"freetype2-devel", rpm:"freetype2-devel~2.1.7~53.17", rls:"SLESSr8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"freetype2", rpm:"freetype2~2.1.3~56", rls:"SLESSr8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"freetype2", rpm:"freetype2~2.0.9~140", rls:"SLESSr8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"freetype2-devel", rpm:"freetype2-devel~2.0.9~140", rls:"SLESSr8"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "NLPOS9")
{

  if(isrpmvuln(pkg:"freetype2", rpm:"freetype2~2.1.7~53.17", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"freetype2-devel", rpm:"freetype2-devel~2.1.7~53.17", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"freetype2", rpm:"freetype2~2.1.3~56", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"freetype2", rpm:"freetype2~2.0.9~140", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"freetype2-devel", rpm:"freetype2-devel~2.0.9~140", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "OES")
{

  if(isrpmvuln(pkg:"freetype2", rpm:"freetype2~2.1.7~53.17", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"freetype2-devel", rpm:"freetype2-devel~2.1.7~53.17", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"freetype2", rpm:"freetype2~2.1.3~56", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"freetype2", rpm:"freetype2~2.0.9~140", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"freetype2-devel", rpm:"freetype2-devel~2.0.9~140", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SLES9")
{

  if(isrpmvuln(pkg:"freetype2", rpm:"freetype2~2.1.7~53.17", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"freetype2-devel", rpm:"freetype2-devel~2.1.7~53.17", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"freetype2", rpm:"freetype2~2.1.3~56", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"freetype2", rpm:"freetype2~2.0.9~140", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"freetype2-devel", rpm:"freetype2-devel~2.0.9~140", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "LES10SP1")
{

  if(isrpmvuln(pkg:"freetype2", rpm:"freetype2~2.1.10~18.14", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"freetype2-devel", rpm:"freetype2-devel~2.1.10~18.14", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "NLDk9")
{

  if(isrpmvuln(pkg:"freetype2", rpm:"freetype2~2.1.7~53.17", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"freetype2-devel", rpm:"freetype2-devel~2.1.7~53.17", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"freetype2", rpm:"freetype2~2.1.3~56", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"freetype2", rpm:"freetype2~2.0.9~140", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"freetype2-devel", rpm:"freetype2-devel~2.0.9~140", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SLESDk10SP1")
{

  if(isrpmvuln(pkg:"freetype2", rpm:"freetype2~2.1.10~18.14", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"freetype2-devel", rpm:"freetype2-devel~2.1.10~18.14", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SL10.1")
{

  if(isrpmvuln(pkg:"freetype2", rpm:"freetype2~2.1.10~18.14", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"freetype2-devel", rpm:"freetype2-devel~2.1.10~18.14", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}