###############################################################################
# OpenVAS Vulnerability Test
#
# SuSE Update for AppArmor SUSE-SA:2007:015
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(850096);
  script_version("$Revision: 1.0 $");
  script_xref(name: "SUSE-SA", value: "2007-015");
  script_cve_id("");
  script_name(english: "SuSE Update for AppArmor SUSE-SA:2007:015");
  desc["english"] = "

  Vulnerability Insight:

  Two new language features have been added to improve the
  confinement provided to applications executing other applications will
  confined by AppArmor.

  - Two new execute modifiers: 'P' and 'U' are provided and are flavors
  of the existing 'p' and 'u' modifiers but indicate that the
  environment should be stripped across the execute transition.

  Using &quot;Ux&quot; and &quot;Px&quot; avoids injecting code using LD_PRELOAD and
  similar variables into the started executables by a infected
  profiled program.

  The environment variable filtering is the same as used for setuid
  applications.

  - A new permission 'm' is required when an application executes
  mmap(2) with protection PROT_EXEC.

  This avoids infected binaries escalating the &quot;r&quot; privilege to a
  file into a &quot;rx&quot; privilege.

  Note that both issues are not directly security fixes, they instead
  avoid common problems during profile creation.

  These changes also require a new kernel, which we released in December
  2006, tracked by our advisory SUSE-SA:2006:079.

  Only SUSE Linux Enterprise Server 9 (and related products) and SUSE
  Linux 10.0 are affected by this change. SUSE Linux 10.1, SUSE Linux
  Enterprise 10 and newer products already contain the new profile
  syntax and behavior.

  Impact:
  AppArmor language additions

  Affected Software/OS:
  AppArmor on SUSE SLES 9, Novell Linux Desktop 9, Open Enterprise Server, Novell Linux POS 9

  Fix: Please Install the Updated Packages.

  References:
  http://www.novell.com/linux/security/advisories/2007_15_apparmor.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of AppArmor");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"SuSE Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "OES")
{

  if(isrpmvuln(pkg:"subdomain-parser", rpm:"subdomain-parser~1.2~42_imnx_suse", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"subdomain-parser-common", rpm:"subdomain-parser-common~1.2~42_imnx_suse", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"subdomain-profiles", rpm:"subdomain-profiles~1.2_SLES9~21_imnx_suse", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"subdomain-utils", rpm:"subdomain-utils~1.2~23_imnx_suse", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"yast2-subdomain", rpm:"yast2-subdomain~1.2~11.1_imnx", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SLES9")
{

  if(isrpmvuln(pkg:"subdomain-parser", rpm:"subdomain-parser~1.2~42_imnx_suse", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"subdomain-parser-common", rpm:"subdomain-parser-common~1.2~42_imnx_suse", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"subdomain-profiles", rpm:"subdomain-profiles~1.2_SLES9~21_imnx_suse", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"subdomain-utils", rpm:"subdomain-utils~1.2~23_imnx_suse", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"yast2-subdomain", rpm:"yast2-subdomain~1.2~11.1_imnx", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "NLDk9")
{

  if(isrpmvuln(pkg:"subdomain-parser", rpm:"subdomain-parser~1.2~42_imnx_suse", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"subdomain-parser-common", rpm:"subdomain-parser-common~1.2~42_imnx_suse", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"subdomain-profiles", rpm:"subdomain-profiles~1.2_SLES9~21_imnx_suse", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"subdomain-utils", rpm:"subdomain-utils~1.2~23_imnx_suse", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"yast2-subdomain", rpm:"yast2-subdomain~1.2~11.1_imnx", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "NLPOS9")
{

  if(isrpmvuln(pkg:"subdomain-parser", rpm:"subdomain-parser~1.2~42_imnx_suse", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"subdomain-parser-common", rpm:"subdomain-parser-common~1.2~42_imnx_suse", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"subdomain-profiles", rpm:"subdomain-profiles~1.2_SLES9~21_imnx_suse", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"subdomain-utils", rpm:"subdomain-utils~1.2~23_imnx_suse", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"yast2-subdomain", rpm:"yast2-subdomain~1.2~11.1_imnx", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}