###############################################################################
# OpenVAS Vulnerability Test
#
# SuSE Update for squid SUSE-SA:2007:012
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(850087);
  script_version("$Revision: 1.0 $");
  script_xref(name: "SUSE-SA", value: "2007-012");
  script_cve_id("CVE-2007-0247", "CVE-2007-0248");
  script_name(english: "SuSE Update for squid SUSE-SA:2007:012");
  desc["english"] = "

  Vulnerability Insight:

  This update fixes a remotely exploitable denial-of-service
  bug in squid that can be triggered by using special ftp://
  URLs. CVE-2007-0247
  Additionally the 10.2 package needed a fix for another DoS
  bug CVE-2007-0248 and for max_user_ip handling in
  ntlm_auth.

  Impact:
  remote denial of service

  Affected Software/OS:
  squid on SUSE LINUX 10.1, openSUSE 10.2, SuSE Linux Enterprise Server 8, SUSE SLES 9, Open Enterprise Server, Novell Linux POS 9, SUSE SLED 10, SUSE SLES 10

  Fix: Please Install the Updated Packages.

  References:
  http://www.novell.com/linux/security/advisories/2007_12_squid.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of squid");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"SuSE Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "openSUSE10.2")
{

  if(isrpmvuln(pkg:"squid", rpm:"squid~2.6.STABLE6~0.4", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SLES10")
{

  if(isrpmvuln(pkg:"squid", rpm:"squid~2.5.STABLE5~42.50", rls:"SLES10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"squid", rpm:"squid~2.5.STABLE12~18.6", rls:"SLES10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SLESSr8")
{

  if(isrpmvuln(pkg:"squid", rpm:"squid~2.5.STABLE5~42.50", rls:"SLESSr8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"squid", rpm:"squid~2.5.STABLE12~18.6", rls:"SLESSr8"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "NLPOS9")
{

  if(isrpmvuln(pkg:"squid", rpm:"squid~2.5.STABLE5~42.50", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"squid", rpm:"squid~2.5.STABLE12~18.6", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "OES")
{

  if(isrpmvuln(pkg:"squid", rpm:"squid~2.5.STABLE5~42.50", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"squid", rpm:"squid~2.5.STABLE12~18.6", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SLES9")
{

  if(isrpmvuln(pkg:"squid", rpm:"squid~2.5.STABLE5~42.50", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"squid", rpm:"squid~2.5.STABLE12~18.6", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SL10.1")
{

  if(isrpmvuln(pkg:"squid", rpm:"squid~2.5.STABLE12~18.6", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SLED10")
{

  if(isrpmvuln(pkg:"squid", rpm:"squid~2.5.STABLE5~42.50", rls:"SLED10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"squid", rpm:"squid~2.5.STABLE12~18.6", rls:"SLED10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}