###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for dbus MDVSA-2008:054 (dbus)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830688);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDVSA", value: "2008:054");
  script_cve_id("CVE-2008-0595");
  script_name(english: "Mandriva Update for dbus MDVSA-2008:054 (dbus)");
  desc["english"] = "

  Vulnerability Insight:

  A vulnerability was discovered by Havoc Pennington in how the
  dbus-daemon applied its security policy.  A user with the ability
  to connect to the dbus-daemon could possibly execute certain method
  calls that they should not normally have access to.
  
  The updated packages have been patched to correct these issues.
  
  Users will have to reboot the system once these packages have been
  installed in order to prevent problems due to service dependencies
  on the messagebus service.

  Affected Software/OS:
  dbus on Mandriva Linux 2007.0,
  Mandriva Linux 2007.0/X86_64,
  Mandriva Linux 2007.1,
  Mandriva Linux 2007.1/X86_64,
  Mandriva Linux 2008.0,
  Mandriva Linux 2008.0/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2008-02/msg00037.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of dbus");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2007.1")
{

  if(isrpmvuln(pkg:"dbus", rpm:"dbus~1.0.2~5.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"dbus-x11", rpm:"dbus-x11~1.0.2~5.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libdbus-1_3", rpm:"libdbus-1_3~1.0.2~5.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libdbus-1_3-devel", rpm:"libdbus-1_3-devel~1.0.2~5.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64dbus-1_3", rpm:"lib64dbus-1_3~1.0.2~5.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64dbus-1_3-devel", rpm:"lib64dbus-1_3-devel~1.0.2~5.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2007.0")
{

  if(isrpmvuln(pkg:"dbus", rpm:"dbus~0.92~8.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"dbus-x11", rpm:"dbus-x11~0.92~8.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libdbus-1_3", rpm:"libdbus-1_3~0.92~8.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libdbus-1_3-devel", rpm:"libdbus-1_3-devel~0.92~8.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64dbus-1_3", rpm:"lib64dbus-1_3~0.92~8.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64dbus-1_3-devel", rpm:"lib64dbus-1_3-devel~0.92~8.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2008.0")
{

  if(isrpmvuln(pkg:"dbus", rpm:"dbus~1.0.2~10.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"dbus-x11", rpm:"dbus-x11~1.0.2~10.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libdbus-1_3", rpm:"libdbus-1_3~1.0.2~10.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libdbus-1_3-devel", rpm:"libdbus-1_3-devel~1.0.2~10.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64dbus-1_3", rpm:"lib64dbus-1_3~1.0.2~10.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64dbus-1_3-devel", rpm:"lib64dbus-1_3-devel~1.0.2~10.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}