###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for qt4 MDVSA-2008:042 (qt4)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830371);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDVSA", value: "2008:042");
  script_cve_id("CVE-2007-5965");
  script_name(english: "Mandriva Update for qt4 MDVSA-2008:042 (qt4)");
  desc["english"] = "

  Vulnerability Insight:

  A potential vulnerability was discovered in Qt4 version 4.3.0 through
  4.3.2 which may cause a certificate verification in SSL connections
  not to be performed.  As a result, code that uses QSslSocket could
  be tricked into thinking that the certificate was verified correctly
  when it actually failed in one or more criteria.
  
  The updated packages have been patched to correct this issue.

  Affected Software/OS:
  qt4 on Mandriva Linux 2008.0,
  Mandriva Linux 2008.0/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2008-02/msg00014.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of qt4");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2008.0")
{

  if(isrpmvuln(pkg:"libqassistant1", rpm:"libqassistant1~4.3.1~12.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libqt3support4", rpm:"libqt3support4~4.3.1~12.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libqt4-devel", rpm:"libqt4-devel~4.3.1~12.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libqtcore4", rpm:"libqtcore4~4.3.1~12.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libqtdbus4", rpm:"libqtdbus4~4.3.1~12.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libqtdesigner1", rpm:"libqtdesigner1~4.3.1~12.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libqtgui4", rpm:"libqtgui4~4.3.1~12.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libqtnetwork4", rpm:"libqtnetwork4~4.3.1~12.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libqtopengl4", rpm:"libqtopengl4~4.3.1~12.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libqtscript4", rpm:"libqtscript4~4.3.1~12.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libqtsql4", rpm:"libqtsql4~4.3.1~12.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libqtsvg4", rpm:"libqtsvg4~4.3.1~12.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libqttest4", rpm:"libqttest4~4.3.1~12.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libqtuitools4", rpm:"libqtuitools4~4.3.1~12.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libqtxml4", rpm:"libqtxml4~4.3.1~12.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qt4-accessibility-plugin-lib", rpm:"qt4-accessibility-plugin-lib~4.3.1~12.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qt4-assistant", rpm:"qt4-assistant~4.3.1~12.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qt4-codecs-plugin-lib", rpm:"qt4-codecs-plugin-lib~4.3.1~12.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qt4-common", rpm:"qt4-common~4.3.1~12.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qt4-database-plugin-mysql-lib", rpm:"qt4-database-plugin-mysql-lib~4.3.1~12.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qt4-database-plugin-odbc-lib", rpm:"qt4-database-plugin-odbc-lib~4.3.1~12.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qt4-database-plugin-pgsql-lib", rpm:"qt4-database-plugin-pgsql-lib~4.3.1~12.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qt4-database-plugin-sqlite-lib", rpm:"qt4-database-plugin-sqlite-lib~4.3.1~12.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qt4-designer", rpm:"qt4-designer~4.3.1~12.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qt4-doc", rpm:"qt4-doc~4.3.1~12.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qt4-examples", rpm:"qt4-examples~4.3.1~12.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qt4-linguist", rpm:"qt4-linguist~4.3.1~12.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qt4-qtdbus", rpm:"qt4-qtdbus~4.3.1~12.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qt4-qvfb", rpm:"qt4-qvfb~4.3.1~12.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qt4-tutorial", rpm:"qt4-tutorial~4.3.1~12.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qt4", rpm:"qt4~4.3.1~12.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64qassistant1", rpm:"lib64qassistant1~4.3.1~12.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64qt3support4", rpm:"lib64qt3support4~4.3.1~12.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64qt4-devel", rpm:"lib64qt4-devel~4.3.1~12.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64qtcore4", rpm:"lib64qtcore4~4.3.1~12.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64qtdbus4", rpm:"lib64qtdbus4~4.3.1~12.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64qtdesigner1", rpm:"lib64qtdesigner1~4.3.1~12.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64qtgui4", rpm:"lib64qtgui4~4.3.1~12.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64qtnetwork4", rpm:"lib64qtnetwork4~4.3.1~12.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64qtopengl4", rpm:"lib64qtopengl4~4.3.1~12.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64qtscript4", rpm:"lib64qtscript4~4.3.1~12.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64qtsql4", rpm:"lib64qtsql4~4.3.1~12.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64qtsvg4", rpm:"lib64qtsvg4~4.3.1~12.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64qttest4", rpm:"lib64qttest4~4.3.1~12.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64qtuitools4", rpm:"lib64qtuitools4~4.3.1~12.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64qtxml4", rpm:"lib64qtxml4~4.3.1~12.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qt4-accessibility-plugin-lib64", rpm:"qt4-accessibility-plugin-lib64~4.3.1~12.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qt4-codecs-plugin-lib64", rpm:"qt4-codecs-plugin-lib64~4.3.1~12.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qt4-database-plugin-mysql-lib64", rpm:"qt4-database-plugin-mysql-lib64~4.3.1~12.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qt4-database-plugin-odbc-lib64", rpm:"qt4-database-plugin-odbc-lib64~4.3.1~12.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qt4-database-plugin-pgsql-lib64", rpm:"qt4-database-plugin-pgsql-lib64~4.3.1~12.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qt4-database-plugin-sqlite-lib64", rpm:"qt4-database-plugin-sqlite-lib64~4.3.1~12.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}