###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for mysql MDVSA-2008:028 (mysql)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830513);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDVSA", value: "2008:028");
  script_cve_id("CVE-2007-2692", "CVE-2007-6304");
  script_name(english: "Mandriva Update for mysql MDVSA-2008:028 (mysql)");
  desc["english"] = "

  Vulnerability Insight:

  The mysql_change_db() function in MySQL 5.0.x before 5.0.40 did not
  restore THD::db_access privileges when returning from SQL SECURITY
  INVOKER stored routines, which allowed remote authenticated users to
  gain privileges (CVE-2007-2692).
  
  The federated engine in MySQL 5.0.x, when performing a certain SHOW
  TABLE STATUS query, did not properly handle a response with a small
  number of columns, which could allow a remote MySQL server to cause
  a denial of service (federated handler crash and daemon crash)
  via a response that lacks the minimum required number of columns
  (CVE-2007-6304).
  
  The updated packages provide MySQL 5.0.45 for all Mandriva Linux
  platforms that shipped with MySQL 5.0.x which offers a number of
  feature enhancements and bug fixes.  In addition, the updates for
  Corporate Server 4.0 include support for the Sphinx engine.
  
  Please note that due to the package name change (from 'MySQL' to
  'mysql'), the mysqld service will not restart automatically so users
  must execute 'service mysqld start' after the upgrade is complete.

  Affected Software/OS:
  mysql on Mandriva Linux 2007.0,
  Mandriva Linux 2007.0/X86_64,
  Mandriva Linux 2007.1,
  Mandriva Linux 2007.1/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2008-01/msg00049.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of mysql");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2007.1")
{

  if(isrpmvuln(pkg:"libmysql-devel", rpm:"libmysql-devel~5.0.45~8.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libmysql-static-devel", rpm:"libmysql-static-devel~5.0.45~8.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libmysql15", rpm:"libmysql15~5.0.45~8.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mysql", rpm:"mysql~5.0.45~8.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mysql-bench", rpm:"mysql-bench~5.0.45~8.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mysql-client", rpm:"mysql-client~5.0.45~8.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mysql-common", rpm:"mysql-common~5.0.45~8.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mysql-max", rpm:"mysql-max~5.0.45~8.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mysql-ndb-extra", rpm:"mysql-ndb-extra~5.0.45~8.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mysql-ndb-management", rpm:"mysql-ndb-management~5.0.45~8.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mysql-ndb-storage", rpm:"mysql-ndb-storage~5.0.45~8.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mysql-ndb-tools", rpm:"mysql-ndb-tools~5.0.45~8.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64mysql-devel", rpm:"lib64mysql-devel~5.0.45~8.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64mysql-static-devel", rpm:"lib64mysql-static-devel~5.0.45~8.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64mysql15", rpm:"lib64mysql15~5.0.45~8.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2007.0")
{

  if(isrpmvuln(pkg:"libmysql-devel", rpm:"libmysql-devel~5.0.45~8.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libmysql-static-devel", rpm:"libmysql-static-devel~5.0.45~8.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libmysql15", rpm:"libmysql15~5.0.45~8.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mysql", rpm:"mysql~5.0.45~8.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mysql-bench", rpm:"mysql-bench~5.0.45~8.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mysql-client", rpm:"mysql-client~5.0.45~8.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mysql-common", rpm:"mysql-common~5.0.45~8.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mysql-max", rpm:"mysql-max~5.0.45~8.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mysql-ndb-extra", rpm:"mysql-ndb-extra~5.0.45~8.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mysql-ndb-management", rpm:"mysql-ndb-management~5.0.45~8.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mysql-ndb-storage", rpm:"mysql-ndb-storage~5.0.45~8.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mysql-ndb-tools", rpm:"mysql-ndb-tools~5.0.45~8.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64mysql-devel", rpm:"lib64mysql-devel~5.0.45~8.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64mysql-static-devel", rpm:"lib64mysql-static-devel~5.0.45~8.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64mysql15", rpm:"lib64mysql15~5.0.45~8.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}