###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for libxfont MDVSA-2008:024 (libxfont)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830463);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDVSA", value: "2008:024");
  script_cve_id("CVE-2008-0006");
  script_name(english: "Mandriva Update for libxfont MDVSA-2008:024 (libxfont)");
  desc["english"] = "

  Vulnerability Insight:

  A heap-based buffer overflow flaw was found in how the X.org server
  handled malformed font files that could allow a malicious local user
  to potentially execute arbitrary code with the privileges of the
  X.org server (CVE-2008-0006).
  
  The updated packages have been patched to correct this issue.

  Affected Software/OS:
  libxfont on Mandriva Linux 2007.0,
  Mandriva Linux 2007.0/X86_64,
  Mandriva Linux 2007.1,
  Mandriva Linux 2007.1/X86_64,
  Mandriva Linux 2008.0,
  Mandriva Linux 2008.0/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2008-01/msg00043.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of libxfont");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2007.1")
{

  if(isrpmvuln(pkg:"libxfont1", rpm:"libxfont1~1.2.7~1.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libxfont1-devel", rpm:"libxfont1-devel~1.2.7~1.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libxfont1-static-devel", rpm:"libxfont1-static-devel~1.2.7~1.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libxfont", rpm:"libxfont~1.2.7~1.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64xfont1", rpm:"lib64xfont1~1.2.7~1.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64xfont1-devel", rpm:"lib64xfont1-devel~1.2.7~1.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64xfont1-static-devel", rpm:"lib64xfont1-static-devel~1.2.7~1.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2007.0")
{

  if(isrpmvuln(pkg:"libxfont1", rpm:"libxfont1~1.1.0~4.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libxfont1-devel", rpm:"libxfont1-devel~1.1.0~4.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libxfont1-static-devel", rpm:"libxfont1-static-devel~1.1.0~4.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libxfont", rpm:"libxfont~1.1.0~4.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64xfont1", rpm:"lib64xfont1~1.1.0~4.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64xfont1-devel", rpm:"lib64xfont1-devel~1.1.0~4.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64xfont1-static-devel", rpm:"lib64xfont1-static-devel~1.1.0~4.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2008.0")
{

  if(isrpmvuln(pkg:"libxfont1", rpm:"libxfont1~1.3.0~3.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libxfont1-devel", rpm:"libxfont1-devel~1.3.0~3.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libxfont1-static-devel", rpm:"libxfont1-static-devel~1.3.0~3.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libxfont", rpm:"libxfont~1.3.0~3.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64xfont1", rpm:"lib64xfont1~1.3.0~3.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64xfont1-devel", rpm:"lib64xfont1-devel~1.3.0~3.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64xfont1-static-devel", rpm:"lib64xfont1-static-devel~1.3.0~3.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}