###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for xen MDKSA-2007:203 (xen)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830116);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDKSA", value: "2007:203");
  script_cve_id("CVE-2007-1320", "CVE-2007-1321", "CVE-2007-5729", "CVE-2007-5730", "CVE-2007-3919", "CVE-2007-4993");
  script_name(english: "Mandriva Update for xen MDKSA-2007:203 (xen)");
  desc["english"] = "

  Vulnerability Insight:

  Tavis Ormandy discovered a heap overflow flaw during video-to-video
  copy operations in the Cirrus VGA extension code that is used in Xen.
  A malicious local administrator of a guest domain could potentially
  trigger this flaw and execute arbitrary code outside of the domain
  (CVE-2007-1320).
  
  Tavis Ormandy also discovered insufficient input validation leading to
  a heap overflow in the NE2000 network driver in Xen.  If the driver
  is in use, a malicious local administrator of a guest domain could
  potentially trigger this flaw and execute arbitrary code outside of
  the domain (CVE-2007-1321, CVE-2007-5729, CVE-2007-5730).
  
  Steve Kemp found that xen-utils used insecure temporary files within
  the xenmon tool that could allow local users to truncate arbitrary
  files (CVE-2007-3919).
  
  Joris van Rantwijk discovered a flaw in Pygrub, which is used as a
  boot loader for guest domains.  A malicious local administrator of
  a guest domain could create a carefully-crafted grub.conf file which
  could trigger the execution of arbitrary code outside of that domain
  (CVE-2007-4993).
  
  Updated packages have been patched to prevent these issues.

  Affected Software/OS:
  xen on Mandriva Linux 2007.0,
  Mandriva Linux 2007.0/X86_64,
  Mandriva Linux 2007.1,
  Mandriva Linux 2007.1/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2007-11/msg00000.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of xen");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2007.1")
{

  if(isrpmvuln(pkg:"xen", rpm:"xen~3.0.3~0.20060703.5.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2007.0")
{

  if(isrpmvuln(pkg:"xen", rpm:"xen~3.0.3~0.20060703.3.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}