###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for jasper MDKSA-2007:129 (jasper)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830150);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDKSA", value: "2007:129");
  script_cve_id("CVE-2007-2721");
  script_name(english: "Mandriva Update for jasper MDKSA-2007:129 (jasper)");
  desc["english"] = "

  Vulnerability Insight:

  A function in the JasPer JPEG-2000 library before 1.900 could allow
  a remote user-assisted attack to cause a crash and possibly corrupt
  the heap via malformed image files.
  
  Updated packages have been patched to prevent this issue.

  Affected Software/OS:
  jasper on Mandriva Linux 2007.0,
  Mandriva Linux 2007.0/X86_64,
  Mandriva Linux 2007.1,
  Mandriva Linux 2007.1/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2007-06/msg00029.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of jasper");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2007.1")
{

  if(isrpmvuln(pkg:"jasper", rpm:"jasper~1.701.0~6.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libjasper1.701_1", rpm:"libjasper1.701_1~1.701.0~6.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libjasper1.701_1-devel", rpm:"libjasper1.701_1-devel~1.701.0~6.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libjasper1.701_1-static-devel", rpm:"libjasper1.701_1-static-devel~1.701.0~6.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64jasper1.701_1", rpm:"lib64jasper1.701_1~1.701.0~6.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64jasper1.701_1-devel", rpm:"lib64jasper1.701_1-devel~1.701.0~6.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64jasper1.701_1-static-devel", rpm:"lib64jasper1.701_1-static-devel~1.701.0~6.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2007.0")
{

  if(isrpmvuln(pkg:"jasper", rpm:"jasper~1.701.0~5.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libjasper1.701_1", rpm:"libjasper1.701_1~1.701.0~5.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libjasper1.701_1-devel", rpm:"libjasper1.701_1-devel~1.701.0~5.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libjasper1.701_1-static-devel", rpm:"libjasper1.701_1-static-devel~1.701.0~5.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64jasper1.701_1", rpm:"lib64jasper1.701_1~1.701.0~5.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64jasper1.701_1-devel", rpm:"lib64jasper1.701_1-devel~1.701.0~5.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64jasper1.701_1-static-devel", rpm:"lib64jasper1.701_1-static-devel~1.701.0~5.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}