###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for samba MDKSA-2007:104-1 (samba)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830209);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDKSA", value: "2007:104-1");
  script_cve_id("CVE-2007-2446", "CVE-2007-2447", "CVE-2007-2444");
  script_name(english: "Mandriva Update for samba MDKSA-2007:104-1 (samba)");
  desc["english"] = "

  Vulnerability Insight:

  A number of bugs were discovered in the NDR parsing support in Samba
  that is used to decode MS-RPC requests.  A remote attacker could
  send a carefully crafted request that would cause a heap overflow,
  possibly leading to the ability to execute arbitrary code on the server
  (CVE-2007-2446).
  
  A remote authenticated user could trigger a flaw where unescaped
  user input parameters were being passed as arguments to /bin/sh
  (CVE-2007-2447).
  
  Finally, on Samba 3.0.23d and higher, when Samba translated SID to/from
  name using the Samba local list of user and group accounts, a logic
  error in smbd's internal security stack could result in a transition
  to the root user id rather than the non-root user (CVE-2007-2444).
  
  Update:
  
  The fix for CVE-2007-2444 broke the behaviour of force group when
  the forced group is a local Unix group for domain member servers.
  
  This update corrects that regression.

  Affected Software/OS:
  samba on Mandriva Linux 2007.0,
  Mandriva Linux 2007.0/X86_64,
  Mandriva Linux 2007.1,
  Mandriva Linux 2007.1/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2007-05/msg00034.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of samba");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2007.1")
{

  if(isrpmvuln(pkg:"libsmbclient0", rpm:"libsmbclient0~3.0.24~2.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libsmbclient0-devel", rpm:"libsmbclient0-devel~3.0.24~2.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libsmbclient0-static-devel", rpm:"libsmbclient0-static-devel~3.0.24~2.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mount-cifs", rpm:"mount-cifs~3.0.24~2.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"nss_wins", rpm:"nss_wins~3.0.24~2.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-client", rpm:"samba-client~3.0.24~2.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-common", rpm:"samba-common~3.0.24~2.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-doc", rpm:"samba-doc~3.0.24~2.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-server", rpm:"samba-server~3.0.24~2.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-smbldap-tools", rpm:"samba-smbldap-tools~3.0.24~2.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-swat", rpm:"samba-swat~3.0.24~2.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-vscan-clamav", rpm:"samba-vscan-clamav~3.0.24~2.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-vscan-icap", rpm:"samba-vscan-icap~3.0.24~2.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-winbind", rpm:"samba-winbind~3.0.24~2.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba", rpm:"samba~3.0.24~2.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64smbclient0", rpm:"lib64smbclient0~3.0.24~2.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64smbclient0-devel", rpm:"lib64smbclient0-devel~3.0.24~2.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64smbclient0-static-devel", rpm:"lib64smbclient0-static-devel~3.0.24~2.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2007.0")
{

  if(isrpmvuln(pkg:"libsmbclient0", rpm:"libsmbclient0~3.0.23d~2.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libsmbclient0-devel", rpm:"libsmbclient0-devel~3.0.23d~2.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libsmbclient0-static-devel", rpm:"libsmbclient0-static-devel~3.0.23d~2.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mount-cifs", rpm:"mount-cifs~3.0.23d~2.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"nss_wins", rpm:"nss_wins~3.0.23d~2.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-client", rpm:"samba-client~3.0.23d~2.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-common", rpm:"samba-common~3.0.23d~2.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-doc", rpm:"samba-doc~3.0.23d~2.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-server", rpm:"samba-server~3.0.23d~2.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-smbldap-tools", rpm:"samba-smbldap-tools~3.0.23d~2.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-swat", rpm:"samba-swat~3.0.23d~2.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-vscan-clamav", rpm:"samba-vscan-clamav~3.0.23d~2.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-vscan-icap", rpm:"samba-vscan-icap~3.0.23d~2.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba-winbind", rpm:"samba-winbind~3.0.23d~2.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"samba", rpm:"samba~3.0.23d~2.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64smbclient0", rpm:"lib64smbclient0~3.0.23d~2.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64smbclient0-devel", rpm:"lib64smbclient0-devel~3.0.23d~2.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64smbclient0-static-devel", rpm:"lib64smbclient0-static-devel~3.0.23d~2.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}