###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for squid MDKSA-2007:068 (squid)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830006);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDKSA", value: "2007:068");
  script_cve_id("CVE-2007-1560");
  script_name(english: "Mandriva Update for squid MDKSA-2007:068 (squid)");
  desc["english"] = "

  Vulnerability Insight:

  Due to an internal error Squid-2.6 is vulnerable to a denial of service
  attack when processing the TRACE request method. This problem allows
  any client trusted to use the service to perform a denial of service
  attack on the Squid service.
  
  Updated packages have been patched to address this issue.

  Affected Software/OS:
  squid on Mandriva Linux 2006.0,
  Mandriva Linux 2006.0/X86_64,
  Mandriva Linux 2007.0,
  Mandriva Linux 2007.0/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2007-03/msg00024.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of squid");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2007.0")
{

  if(isrpmvuln(pkg:"squid", rpm:"squid~2.6.STABLE1~4.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"squid-cachemgr", rpm:"squid-cachemgr~2.6.STABLE1~4.3mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2006.0")
{

  if(isrpmvuln(pkg:"squid", rpm:"squid~2.5.STABLE10~10.4.20060mdk", rls:"MNDK_2006.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"squid-cachemgr", rpm:"squid-cachemgr~2.5.STABLE10~10.4.20060mdk", rls:"MNDK_2006.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}