###############################################################################
# OpenVAS Vulnerability Test
#
# HP-UX Update for PAM Kerberos HPSBUX02415
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(835193);
  script_version("$Revision: 1.0 $");
  script_xref(name: "HPSBUX", value: "02415");
  script_cve_id("CVE-2009-0360", "CVE-2009-0361");
  script_name(english: "HP-UX Update for PAM Kerberos HPSBUX02415");
  desc["english"] = "

  Vulnerability Insight:
  A potential security vulnerability has been identified with HP-UX running 
  PAM Kerberos. The vulnerability could be exploited locally to create a 
  privilege escalation or to allow an unauthorized access. 

  Impact:
  Local privilege escalation
  local unauthorized access

  Affected Software/OS:
  PAM Kerberos on
  HP-UX B.11.11, B.11.23, B.11.31 running PAM Kerberos 

  Fix: Please Install the Updated Packages.

  References:
  http://www11.itrc.hp.com/service/cki/docDisplay.do?docId=emr_na-c01690019-1

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of PAM Kerberos");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"HP-UX Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-hpux.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "HPUX11.31")
{

  if(ishpuxpkgvuln(pkg:"PAM-Kerberos.PAM-KRB-64SLIB", revision:"D.01.25", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"PAM-Kerberos.PAM-KRB-DEMO", revision:"D.01.25", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"PAM-Kerberos.PAM-KRB-I64LIB", revision:"D.01.25", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"PAM-Kerberos.PAM-KRB-IASLIB", revision:"D.01.25", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"PAM-Kerberos.PAM-KRB-MAN", revision:"D.01.25", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"PAM-Kerberos.PAM-KRB-RUN", revision:"D.01.25", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"PAM-Kerberos.PAM-KRB-SHLIB", revision:"D.01.25", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.23")
{

  if(ishpuxpkgvuln(pkg:"PAM-Kerberos.PAM-KRB-64SLIB", revision:"C.01.25", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"PAM-Kerberos.PAM-KRB-DEMO", revision:"C.01.25", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"PAM-Kerberos.PAM-KRB-I64LIB", revision:"C.01.25", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"PAM-Kerberos.PAM-KRB-IASLIB", revision:"C.01.25", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"PAM-Kerberos.PAM-KRB-MAN", revision:"C.01.25", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"PAM-Kerberos.PAM-KRB-RUN", revision:"C.01.25", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"PAM-Kerberos.PAM-KRB-SHLIB", revision:"C.01.25", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.11")
{

  if(ishpuxpkgvuln(pkg:"KRBS-Support.KRBS-SUPP-MAN", revision:"B.11.11.16", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"KRBS-Support.KRBS-SUPP-NOTE", revision:"B.11.11.16", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"KRBS-Support.KRBS-SUPP-RUN", revision:"B.11.11.16", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"PAM-Kerberos.PAM-KRB-64SLIB", revision:"B.11.11.16", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"PAM-Kerberos.PAM-KRB-DEMO", revision:"B.11.11.16", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"PAM-Kerberos.PAM-KRB-MAN", revision:"B.11.11.16", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"PAM-Kerberos.PAM-KRB-RUN", revision:"B.11.11.16", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"PAM-Kerberos.PAM-KRB-SHLIB", revision:"B.11.11.16", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}