###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_graphicsmagick_detect_lin.nasl 1015 2009-02-16 12:21:12Z feb $
#
# GraphicsMagick Version Detection (Linux)
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800516);
  script_version("$Revision: 1.0 $");
  script_name(english:"GraphicsMagick Version Detection (Linux)");
  desc["english"] = "

  Overview: This script detects the installed version of GraphicsMagick
  and sets the version in KB.

  Risk factor: Informational";

  script_description(english:desc["english"]);
  script_summary(english:"Sets KB for Version of GraphicsMagick");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"General");
  exit(0);
}


include("version_func.inc");

sock = ssh_login_or_reuse_connection();
if(!sock){
  exit(0);
}

gmName = find_file(file_name:"gm", file_path:"/", useregex:TRUE,
                   regexpar:"$", sock:sock);
foreach binary_gmName(gmName)
{
  binary_name = chomp(binary_gmName);
  gmVer = get_bin_version(full_prog_name:binary_name, version_argv:"-version",
                          ver_pattern:"[0-9]\.[0-9.]+", sock:sock);
  if(gmVer[0] != NULL)
  {
    set_kb_item(name:"GraphicsMagick/Linux/Ver", value:gmVer[0]);
    ssh_close_connection();
    exit(0);
  }
}
ssh_close_connection();
