###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_gale_sec_bypass_vuln.nasl 826 2009-01-15 17:45:27Z jan $
#
# Gale EVP_VerifyFinal() Security Bypass Vulnerability
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800340);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-0047");
  script_bugtraq_id(33150);
  script_name(english:"Gale EVP_VerifyFinal() Security Bypass Vulnerability");
  desc["english"] = "

  Overview: The host is running Gale and is prone to security bypass
  vulnerability.

  Vulnerability Insight:
  The flaw is caused due to improper validation of return value in
  EVP_VerifyFinal function of openssl.

  Impact:
  Successful exploitation could allow remote attackers to bypass the certificate
  validation checks and can cause spoofing attacks via signature checks on DSA
  and ECDSA keys used with SSL/TLS.

  Impact Level: System/Application

  Affected Software/OS:
  Gale version 0.99 and prior on Linux.

  Fix: No solution or patch is available as on 19th January, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.gale.org/

  References:
  http://www.securityfocus.com/archive/1/499855
  http://www.ocert.org/advisories/ocert-2008-016.html
  http://web.nvd.nist.gov/view/vuln/detail?vulnId=CVE-2009-0047

  CVSS Score:
    CVSS Base Score     : 5.0 (AV:N/AC:L/Au:NR/C:P/I:N/A:N)
    CVSS Temporal Score : 4.2
  Risk factor: Medium";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of Gale");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"General");
  script_dependencies("gb_gale_detect.nasl");
  script_require_keys("Gale/Linux/Ver");
  exit(0);
}


include("version_func.inc");

galePort = 11512;
if(!get_udp_port_state(galePort)){
  exit(0);
}

galeVer = get_kb_item("Gale/Linux/Ver");
if(!galeVer){
  exit(0);
}

# version 0.99 and prior
if(version_is_less_equal(version:galeVer, test_version:"0.99")){
  security_warning(galePort);
}
