###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_free_download_mang_mult_bof_vuln.nasl 960 2009-02-04 20:48:29Z feb $
#
# Multiple Buffer Overflow Vulnerabilities in Free Download Manager
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800349);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-0183", "CVE-2009-0184");
  script_bugtraq_id(33554, 33555);
  script_name(english:"Multiple Buffer Overflow Vulnerabilities in Free Download Manager");
  desc["english"] = "

  Overview: This host has installed Free Download Manager and is prone to
  multiple buffer overflow vulnerability.

  Vulnerability Insight:
  Multiple buffer overflow errors due to,
  - a long file name within a torrent file.
  - a long tracker URL in a torrent file.
  - a long comment in a torrent file.
  - a long Authorization header in an HTTP request.

  Impact:
  Successful exploitation could allow remote attackers to execute arbitrary
  code and can cause denial-of-service in the affected application.

  Impact Level: Application

  Affected Software/OS:
  Free Download Manager version prior to 3.0 build 848 on Windows.

  Fix: Upgrade to version 3.0 bulid 848
  http://www.freedownloadmanager.org/download.htm

  References:
  http://secunia.com/advisories/33524
  http://secunia.com/secunia_research/2009-3/
  http://secunia.com/secunia_research/2009-5/
  http://downloads.securityfocus.com/vulnerabilities/exploits/33555-SkD.pl

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 7.4
  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the version of Free Download Manager");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Buffer overflow");
  script_dependencies("gb_free_download_mang_detect.nasl");
  script_require_keys("FreeDownloadManager/Ver");
  exit(0);
}


include("version_func.inc");

fdmVer = get_kb_item("FreeDownloadManager/Ver");
if(!fdmVer){
  exit(0);
}

# Grep for Chrome version prior to 3.0 build 848
if(version_is_less(version:fdmVer, test_version:"3.0.848.0")){
  security_hole(0);
}
