###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_firefox_dos_vuln_may09_lin.nasl 2121 -05-05-2009 21:25:33Z may $
#
# Mozilla Firefox DoS Vulnerability May-09 (Linux)
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800398);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-1313");
  script_bugtraq_id(34743);
  script_name(english:"Mozilla Firefox DoS Vulnerability May-09 (Linux)");
  desc["english"] = "

  Overview: The host is installed with Mozilla Firefox browser and is prone
  to Denial of Service vulnerability.

  Vulnerability Insight:
  The flaw is caused due to error in nsTextFrame::ClearTextRun function in
  layout/generic/nsTextFrameThebes.cpp via unspecified vectors.

  Impact:
  Successful exploitation will let attackers to execute arbitrary code which
  results in memory corruption.

  Impact Level: Application

  Affected Software/OS:
  Firefox version prior to 3.0.10 on Linux.

  Fix: Upgrade to Firefox version 3.0.10
  http://www.mozilla.com/en-US/firefox/all.html

  References:
  https://rhn.redhat.com/errata/RHSA-2009-0449.html
  https://bugzilla.mozilla.org/show_bug.cgi?id=490233
  http://securitytracker.com/alerts/2009/Apr/1022126.html
  http://www.mozilla.org/security/announce/2009/mfsa2009-23.html

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 6.9
  Risk factor: Medium";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the version of Firefox");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Denial of Service");
  script_dependencies("gb_firefox_detect_lin.nasl");
  script_require_keys("Firefox/Linux/Ver");
  exit(0);
}


include("version_func.inc");

ffVer = get_kb_item("Firefox/Linux/Ver");
if(!ffVer){
  exit(0);
}

# Grep for Firefox version < 3.0.10
if(version_is_less(version:ffVer, test_version:"3.0.10")){
  security_warning(0);
}
