###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_elecard_mpeg_player_bof_vuln.nasl 1001 2009-02-10 15:56:36Z feb $
#
# Elecard MPEG Player Buffer Overflow Vulnerability
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800511);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-0491");
  script_bugtraq_id(33089);
  script_name(english:"Elecard MPEG Player Buffer Overflow Vulnerability");
  desc["english"] = "

  Overview: This host is running Elecard MPEG Player and is prone to Buffer
  Overflow Vulnerability.

  Vulnerability Insight:
  Issue is with boundary error while processing playlist 'm3u' files, which
  may contain crafted long URLs.

  Impact: Successful exploitation will let the attacker execute arbitrary
  codes in the context of the application and may cause stack overflow in
  the application.

  Affected Software/OS:
  Elecard MPEG Player 5.5 build 15884.081218 and prior.

  Fix:
  No solution or patch is available as on 16th February, 2009.Information
  regarding this issue will be updated once the solution details are available.
  For updates refer,
  http://www.elecard.com/products/products-pc/consumer/mpeg-player

  References:
  http://osvdb.org/51075
  http://secunia.com/advisories/33355
  http://www.milw0rm.com/exploits/7637

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 8.4
  Risk factor: Critical";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the version of Elecard MPEG Player");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Buffer overflow");
  script_dependencies("gb_elecard_mpeg_player_detect.nasl");
  script_require_keys("Elecard/Player/Ver");
  exit(0);
}


include("version_func.inc");

epVer = get_kb_item("Elecard/Player/Ver");
if(epVer == NULL){
  exit(0);
}

if(version_is_less_equal(version:epVer, test_version:"5.5.15884.081218")){
  security_hole(0);
}
