###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_ayeview_gif_dos_vul.nasl 0844 2009-01-13 13:54:36Z Jan $ 
# 
# AyeView GIF Image Handling Denial of Service Vulnerability
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800503);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-5884");
  script_bugtraq_id(31572);
  script_name(english:"AyeView GIF Image Handling Denial of Service Vulnerability");
  desc["english"] = "

  Overview: The host has AyeView Image Viewer installed and is prone to denial
  of service vulnerability.

  Vulnerability Insight:
  Flaw is due to an error generated while handling GIF file. These .gif files
  contain a malformed header.
  
  Impact: Successful remote exploitation could result in Denial of Service.

  Impact Level: Application

  Affected Software/OS:
  AyeView version 2.20 and prior on Windows.

  Fix: No solution or patch is available as on 15th January, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.ayeview.com/

  References:
  http://web.nvd.nist.gov/view/vuln/detail?execution=e1s1
  http://www.security-database.com/detail.php?alert=CVE-2008-5884
  http://www.securityfocus.com/archive/1/archive/1/497045/100/0/threaded

  CVSS Score:
    CVSS Base Score     : 4.3 (AV:N/AC:M/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score : 3.9
  Risk factor : Medium";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the version of AyeView");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Denial of Service");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  exit(0);
}


include("smb_nt.inc");
include("version_func.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

verStr = registry_get_sz(key:"SOFTWARE\Microsoft\Windows\CurrentVersion" +
                             "\Uninstall\AyeView_is1", item:"DisplayName");
if(!verStr){
  exit(0);
}

avVer = eregmatch(pattern:"AyeView version ([0-9.]+)", string:verStr);
if(!avVer[1] != NULL){
  exit(0);
}

if(version_is_less_equal(version:avVer[1], test_version:"2.20")){
  security_warning(0);
}
