###############################################################################
# OpenVAS Vulnerability Test
#
# CentOS Update for irb CESA-2008:0897 centos4 x86_64
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(880070);
  script_version("$Revision: 1.0 $");
  script_xref(name: "CESA", value: "2008:0897");
  script_cve_id("CVE-2008-3443", "CVE-2008-3655", "CVE-2008-3656", "CVE-2008-3657", "CVE-2008-3790", "CVE-2008-3905");
  script_name(english: "CentOS Update for irb CESA-2008:0897 centos4 x86_64");
  desc["english"] = "

  Vulnerability Insight:
  Ruby is an interpreted scripting language for quick and easy
  object-oriented programming.
  
  The Ruby DNS resolver library, resolv.rb, used predictable transaction IDs
  and a fixed source port when sending DNS requests. A remote attacker could
  use this flaw to spoof a malicious reply to a DNS query. (CVE-2008-3905)
  
  Ruby's XML document parsing module (REXML) was prone to a denial of service
  attack via XML documents with large XML entity definitions recursion. A
  specially-crafted XML file could cause a Ruby application using the REXML
  module to use an excessive amount of CPU and memory. (CVE-2008-3790)
  
  An insufficient &quot;taintness&quot; check flaw was discovered in Ruby's DL module,
  which provides direct access to the C language functions. An attacker could
  use this flaw to bypass intended safe-level restrictions by calling
  external C functions with the arguments from an untrusted tainted inputs.
  (CVE-2008-3657)
  
  A denial of service flaw was discovered in WEBrick, Ruby's HTTP server
  toolkit. A remote attacker could send a specially-crafted HTTP request to a
  WEBrick server that would cause the server to use an excessive amount of
  CPU time. (CVE-2008-3656)
  
  A number of flaws were found in the safe-level restrictions in Ruby. It
  was possible for an attacker to create a carefully crafted malicious script
  that can allow the bypass of certain safe-level restrictions. (CVE-2008-3655)
  
  A denial of service flaw was found in Ruby's regular expression engine. If
  a Ruby script tried to process a large amount of data via a regular
  expression, it could cause Ruby to enter an infinite-loop and crash.
  (CVE-2008-3443)
  
  Users of ruby should upgrade to these updated packages, which contain
  backported patches to resolve these issues.


  Affected Software/OS:
  irb on CentOS 4

  Fix: Please Install the Updated Packages.

  References:
  http://lists.centos.org/pipermail/centos-announce/2008-October/015354.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of irb");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"CentOS Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "CENTOS4")
{

  if(isrpmvuln(pkg:"irb", rpm:"irb~1.8.1~7.el4_7.1", rls:"CENTOS4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ruby", rpm:"ruby~1.8.1~7.el4_7.1", rls:"CENTOS4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ruby-devel", rpm:"ruby-devel~1.8.1~7.el4_7.1", rls:"CENTOS4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ruby-docs", rpm:"ruby-docs~1.8.1~7.el4_7.1", rls:"CENTOS4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ruby-libs", rpm:"ruby-libs~1.8.1~7.el4_7.1", rls:"CENTOS4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ruby-mode", rpm:"ruby-mode~1.8.1~7.el4_7.1", rls:"CENTOS4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ruby-tcltk", rpm:"ruby-tcltk~1.8.1~7.el4_7.1", rls:"CENTOS4"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}