###############################################################################
# OpenVAS Vulnerability Test
#
# CentOS Update for ruby CESA-2008:0895-02 centos2 i386
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(880179);
  script_version("$Revision: 1.0 $");
  script_xref(name: "CESA", value: "2008:0895-02");
  script_cve_id("CVE-2008-3443", "CVE-2008-3655");
  script_name(english: "CentOS Update for ruby CESA-2008:0895-02 centos2 i386");
  desc["english"] = "

  Vulnerability Insight:
  Ruby is an interpreted scripting language for quick and easy
  object-oriented programming.
  
  A number of flaws were found in the safe-level restrictions in Ruby. It
  was possible for an attacker to create a carefully crafted malicious script
  that can allow the bypass of certain safe-level restrictions. (CVE-2008-3655)
  
  A denial of service flaw was found in Ruby's regular expression engine. If
  a Ruby script tried to process a large amount of data via a regular
  expression, it could cause Ruby to enter an infinite-loop and crash.
  (CVE-2008-3443)
  
  Users of ruby should upgrade to these updated packages, which contain
  backported patches to resolve these issues.


  Affected Software/OS:
  ruby on CentOS 2

  Fix: Please Install the Updated Packages.

  References:
  http://lists.centos.org/pipermail/centos-announce/2008-October/015336.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of ruby");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"CentOS Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "CENTOS2")
{

  if(isrpmvuln(pkg:"irb", rpm:"irb~1.6.4~7.el2", rls:"CENTOS2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ruby", rpm:"ruby~1.6.4~7.el2", rls:"CENTOS2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ruby-devel", rpm:"ruby-devel~1.6.4~7.el2", rls:"CENTOS2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ruby-docs", rpm:"ruby-docs~1.6.4~7.el2", rls:"CENTOS2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ruby-libs", rpm:"ruby-libs~1.6.4~7.el2", rls:"CENTOS2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ruby-tcltk", rpm:"ruby-tcltk~1.6.4~7.el2", rls:"CENTOS2"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}