#
#ADV FreeBSD-SA-06:18.ppp.asc
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
#
                                                                                
if(description)
{
 script_id(57294);
 script_cve_id("CVE-2006-4304");
 script_version ("$");
 name["english"] = "FreeBSD Security Advisory (FreeBSD-SA-06:18.ppp.asc)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to the system
as announced in the referenced advisory FreeBSD-SA-06:18.ppp.asc

The ppp(4) driver implements the Point-to-Point Protocol for using serial
lines (e.g., modems) as network interfaces.

While processing Link Control Protocol (LCP) configuration options received
from the remote host, ppp(4) fails to correctly validate option lengths.
This may result in data being read or written beyond the allocated kernel
memory buffer.

Solution:
Upgrade your system to the appropriate stable release
or security branch dated after the correction date

https://secure1.securityspace.com/smysecure/catid.html?in=FreeBSD-SA-06:18.ppp.asc
Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "FreeBSD Security Advisory (FreeBSD-SA-06:18.ppp.asc)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2006 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdpatchlevel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
if(patchlevelcmp(rel:"6.1", patchlevel:"4")<0) {
    vuln = 1;
}
if(patchlevelcmp(rel:"6.0", patchlevel:"10")<0) {
    vuln = 1;
}
if(patchlevelcmp(rel:"5.5", patchlevel:"3")<0) {
    vuln = 1;
}
if(patchlevelcmp(rel:"5.4", patchlevel:"17")<0) {
    vuln = 1;
}
if(patchlevelcmp(rel:"5.3", patchlevel:"32")<0) {
    vuln = 1;
}
if(patchlevelcmp(rel:"4.11", patchlevel:"20")<0) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
