#
#VID 800e8bd5-3acb-11dd-8842-001302a18722
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(61190);
 script_cve_id("CVE-2008-1377", "CVE-2008-1379", "CVE-2008-2360", "CVE-2008-2361", "CVE-2008-2362");
 script_version ("$");
 name["english"] = "FreeBSD Ports: xorg-server";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: xorg-server

CVE-2008-1377
The (1) SProcRecordCreateContext and (2) SProcRecordRegisterClients
functions in the Record extension and the (3)
SProcSecurityGenerateAuthorization function in the Security extension
in the X server 1.4 in X.Org X11R7.3 allow context-dependent attackers
to execute arbitrary code via requests with crafted length values that
specify an arbitrary number of bytes to be swapped on the heap, which
triggers heap corruption.

CVE-2008-1379
Integer overflow in the fbShmPutImage function in the MIT-SHM
extension in the X server 1.4 in X.Org X11R7.3 allows
context-dependent attackers to read arbitrary process memory via
crafted values for a Pixmap width and height.

CVE-2008-2360
Integer overflow in the AllocateGlyph function in the Render extension
in the X server 1.4 in X.Org X11R7.3 allows context-dependent
attackers to execute arbitrary code via unspecified request fields
that are used to calculate a heap buffer size, which triggers a
heap-based buffer overflow.

CVE-2008-2361
Integer overflow in the ProcRenderCreateCursor function in the Render
extension in the X server 1.4 in X.Org X11R7.3 allows
context-dependent attackers to cause a denial of service (daemon
crash) via unspecified request fields that are used to calculate a
glyph buffer size, which triggers a dereference of unmapped memory.

CVE-2008-2362
Multiple integer overflows in the Render extension in the X server 1.4
in X.Org X11R7.3 allow context-dependent attackers to execute
arbitrary code via a (1) SProcRenderCreateLinearGradient, (2)
SProcRenderCreateRadialGradient, or (3)
SProcRenderCreateConicalGradient request with an invalid field
specifying the number of bytes to swap in the request data, which
triggers heap memory corruption.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://lists.freedesktop.org/archives/xorg/2008-June/036026.html
http://secunia.com/advisories/30627/
http://www.vuxml.org/freebsd/800e8bd5-3acb-11dd-8842-001302a18722.html

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "FreeBSD Ports: xorg-server";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"xorg-server");
if(!isnull(bver) && revcomp(a:bver, b:"1.4.2,1")<0) {
    security_note(0, data:"Package xorg-server version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
