#
#VID 2797b27a-f55b-11d8-81b0-000347a4fa7d
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(52414);
 script_cve_id("CVE-2004-0746");
 script_bugtraq_id(10991);
 script_version ("$");
 name["english"] = "FreeBSD Ports: kdelibs";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: kdelibs

CVE-2004-0746
Konqueror in KDE 3.2.3 and earlier allows web sites to set cookies for
country-specific top-level domains, such as .ltd.uk, .plc.uk and
.firm.in, which could allow remote attackers to perform a session
fixation attack and hijack a user's HTTP session.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://www.kde.org/info/security/advisory-20040823-1.txt
http://www.osvdb.org/9117
http://secunia.com/advisories/12341
http://www.acros.si/papers/session_fixation.pdf
http://www.vuxml.org/freebsd/2797b27a-f55b-11d8-81b0-000347a4fa7d.html

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "FreeBSD Ports: kdelibs";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"kdelibs");
if(!isnull(bver) && revcomp(a:bver, b:"3.2.3_3")<0) {
    security_note(0, data:"Package kdelibs version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
