#
#VID 67bd39ba-12b5-11dd-bab7-0016179b2dd5
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(60886);
 script_cve_id("CVE-2008-1237", "CVE-2008-1380");
 script_bugtraq_id(28818);
 script_version ("$");
 name["english"] = "FreeBSD Ports: firefox";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to the system
as announced in the referenced advisory.

The following packages are affected:
   firefox
   linux-firefox
   seamonkey
   linux-seamonkey
   flock
   linux-flock
   linux-firefox-devel
   linux-seamonkey-devel
   thunderbird
   linux-thunderbird

CVE-2008-1237
Multiple unspecified vulnerabilities in Mozilla Firefox before
2.0.0.13, Thunderbird before 2.0.0.13, and SeaMonkey before 1.1.9
allow remote attackers to cause a denial of service (crash) and
possibly execute arbitrary code via unknown vectors related to the
JavaScript engine.
CVE-2008-1380
The JavaScript engine in Mozilla Firefox before 2.0.0.14, Thunderbird
before 2.0.0.14, and SeaMonkey before 1.1.10 allows remote attackers
to cause a denial of service (garbage collector crash) and possibly
have other impacts via a crafted web page.  NOTE: this is due to an
incorrect fix for CVE-2008-1237.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://secunia.com/advisories/29787
http://www.mozilla.org/security/announce/2008/mfsa2008-20.html
http://www.vuxml.org/freebsd/67bd39ba-12b5-11dd-bab7-0016179b2dd5.html

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "FreeBSD Ports: firefox";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"firefox");
if(!isnull(bver) && revcomp(a:bver, b:"2.0.0.14,1")<0) {
    security_note(0, data:"Package firefox version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"linux-firefox");
if(!isnull(bver) && revcomp(a:bver, b:"2.0.0.14")<0) {
    security_note(0, data:"Package linux-firefox version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"seamonkey");
if(!isnull(bver) && revcomp(a:bver, b:"1.1.10")<0) {
    security_note(0, data:"Package seamonkey version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"linux-seamonkey");
if(!isnull(bver) && revcomp(a:bver, b:"1.1.10")<0) {
    security_note(0, data:"Package linux-seamonkey version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"flock");
if(!isnull(bver) && revcomp(a:bver, b:"1.1.2")<0) {
    security_note(0, data:"Package flock version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"linux-flock");
if(!isnull(bver) && revcomp(a:bver, b:"1.1.2")<0) {
    security_note(0, data:"Package linux-flock version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"linux-firefox-devel");
if(!isnull(bver) && revcomp(a:bver, b:"0")>0) {
    security_note(0, data:"Package linux-firefox-devel version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"linux-seamonkey-devel");
if(!isnull(bver) && revcomp(a:bver, b:"0")>0) {
    security_note(0, data:"Package linux-seamonkey-devel version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"thunderbird");
if(!isnull(bver) && revcomp(a:bver, b:"2.0.0.14")<0) {
    security_note(0, data:"Package thunderbird version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"linux-thunderbird");
if(!isnull(bver) && revcomp(a:bver, b:"2.0.0.14")<0) {
    security_note(0, data:"Package linux-thunderbird version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
