#
#VID 87106b67-be13-11dd-a578-0030843d3802
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from VID 87106b67-be13-11dd-a578-0030843d3802
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(61957);
 script_cve_id("CVE-2008-1722", "CVE-2008-5184");
 script_version ("$");
 name["english"] = "FreeBSD Ports: cups-base";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: cups-base

CVE-2008-1722
Multiple integer overflows in (1) filter/image-png.c and (2)
filter/image-zoom.c in CUPS 1.3 allow attackers to cause a denial of
service (crash) and trigger memory corruption, as demonstrated via a
crafted PNG image.

CVE-2008-5184
The web interface (cgi-bin/admin.c) in CUPS before 1.3.8 uses the
guest username when a user is not logged on to the web server, which
makes it easier for remote attackers to bypass intended policy and
conduct CSRF attacks via the (1) add and (2) cancel RSS subscription
functions.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://secunia.com/advisories/30190
http://www.cups.org/str.php?L2974
http://www.vuxml.org/freebsd/87106b67-be13-11dd-a578-0030843d3802.html

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "FreeBSD Ports: cups-base";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"cups-base");
if(!isnull(bver) && revcomp(a:bver, b:"1.3.9_2")<0) {
    security_note(0, data:"Package cups-base version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
