# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 942-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(56187);
 script_bugtraq_id(16252);
 script_cve_id("CVE-2006-0044");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 942-1 (albatross)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to albatross
announced via advisory DSA 942-1.

A design error has been discovered in the Albatross web application
toolkit that causes user supplied data to be used as part of template
execution and hence arbitrary code execution.

The old stable distribution (woody) does not contain albatross packages.

For the stable distribution (sarge) this problem has been fixed in
version 1.20-2.

For the unstable distribution (sid) this problem has been fixed in
version 1.33-1.

We recommend that you upgrade your albatross package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20942-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 942-1 (albatross)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2006 E-Soft Inc. http://www.securiytspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"python-albatross-common", ver:"1.20-2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python-albatross-doc", ver:"1.20-2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python-albatross", ver:"1.20-2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python2.2-albatross", ver:"1.20-2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python2.3-albatross", ver:"1.20-2", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
