# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 804-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(55260);
 script_bugtraq_id(14297);
 script_cve_id("CVE-2005-1920");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 804-1 (kdelibs)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to kdelibs
announced via advisory DSA 804-1.

KDE developers have reported a vulnerability in the backup file
handling of Kate and Kwrite.  The backup files are created with
default permissions, even if the original file had more strict
permissions set.  This could disclose information unintendedly.

For the stable distribution (sarge) this problem has been fixed in
version 3.3.2-6.2.

For the unstable distribution (sid) these problems have been fixed in
version 3.4.1-1.

We recommend that you upgrade your kate package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20804-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 804-1 (kdelibs)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"kdelibs-data", ver:"3.3.2-6.2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdelibs4-doc", ver:"3.3.2-6.2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdelibs", ver:"3.3.2-6.2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdelibs-bin", ver:"3.3.2-6.2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdelibs4", ver:"3.3.2-6.2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdelibs4-dev", ver:"3.3.2-6.2", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
