# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 689-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53519);
 script_bugtraq_id(12519);
 script_cve_id("CVE-2005-0088");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 689-1 (libapache-mod-python)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to libapache-mod-python
announced via advisory DSA 689-1.

Graham Dumpleton discovered a flaw which can affect anyone using the
publisher handle of the Apache Software Foundation's mod_python.  The
publisher handle lets you publish objects inside modules to make them
callable via URL.  The flaw allows a carefully crafted URL to obtain
extra information that should not be visible (information leak).

For the stable distribution (woody) this problem has been fixed in
version 2.7.8-0.0woody5.

For the unstable distribution (sid) this problem has been fixed in
version 2.7.10-4 of libapache-mod-python and in version 3.1.3-3 of
libapache2-mod-python.

We recommend that you upgrade your libapache-mod-python package.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20689-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 689-1 (libapache-mod-python)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libapache-mod-python", ver:"2.7.8-0.0woody5", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
