# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 543-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53233);
 script_cve_id("CVE-2004-0642", "CVE-2004-0643", "CVE-2004-0644", "CVE-2004-0772");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 543-1 (krb5)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to krb5
announced via advisory DSA 543-1.

The MIT Kerberos Development Team has discovered a number of
vulnerabilities in the MIT Kerberos Version 5 software.  The Common
Vulnerabilities and Exposures project identifies the following
vulnerabilities:

CVE-2004-0642 [VU#795632]

A double-free error may allow unauthenticated remote attackers to
execute arbitrary code on KDC or clients.

CVE-2004-0643 [VU#866472]

Several double-free errors may allow authenticated attackers to
execute arbitrary code on Kerberos application servers.

CVE-2004-0644 [VU#550464]

A remotely eploitable denial of service vulnerability has been
found in the KDC and libraries.

CVE-2004-0772 [VU#350792]

Several double-free errors may allow remote attackers to execute
arbitrary code on the server.  This does not affect the version in
woody.

For the stable distribution (woody) these problems have been fixed in
version 1.2.4-5woody6.

For the unstable distribution (sid) these problems have been fixed in
version 1.3.4-3.

We recommend that you upgrade your krb5 packages.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20543-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 543-1 (krb5)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"krb5-doc", ver:"1.2.4-5woody6", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"krb5-admin-server", ver:"1.2.4-5woody6", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"krb5-clients", ver:"1.2.4-5woody6", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"krb5-ftpd", ver:"1.2.4-5woody6", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"krb5-kdc", ver:"1.2.4-5woody6", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"krb5-rsh-server", ver:"1.2.4-5woody6", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"krb5-telnetd", ver:"1.2.4-5woody6", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"krb5-user", ver:"1.2.4-5woody6", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libkadm55", ver:"1.2.4-5woody6", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libkrb5-dev", ver:"1.2.4-5woody6", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libkrb53", ver:"1.2.4-5woody6", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
