# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 513-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53204);
 script_bugtraq_id(10460);
 script_cve_id("CVE-2004-0450");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 513-1 (log2mail)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to log2mail
announced via advisory DSA 513-1.

jaguar@felinemenace.org discovered a format string vulnerability in
log2mail, whereby a user able to log a specially crafted message to a
logfile monitored by log2mail (for example, via syslog) could cause
arbitrary code to be executed with the privileges of the log2mail
process.  By default, this process runs as user 'log2mail', which is a
member of group 'adm' (which has access to read system logfiles).

CVE-2004-0450: log2mail format string vulnerability via syslog(3) in
printlog()

For the current stable distribution (woody), this problem has been
fixed in version 0.2.5.2.

For the unstable distribution (sid), this problem will be fixed soon.

We recommend that you update your log2mail package.



Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20513-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 513-1 (log2mail)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"log2mail", ver:"0.2.5.2", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
