# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 502-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53192);
 script_cve_id("CVE-2004-0399", "CVE-2004-0400");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 502-1 (exim-tls)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to exim-tls
announced via advisory DSA 502-1.

Georgi Guninski discovered two stack-based buffer overflows in exim
and exim-tls.  They can not be exploited with the default
configuration from the Debian system, though.  The Common
Vulnerabilities and Exposures project identifies the following
problems that are fixed with this update:

CVE-2004-0399

When sender_verify = true is configured in exim.conf a buffer
overflow can happen during verification of the sender.  This
problem is fixed in exim 4.

CVE-2004-0400

When headers_check_syntax is configured in exim.conf a buffer
overflow can happen during the header check.  This problem does
also exist in exim 4.

For the stable distribution (woody) these problems have been fixed in
version 3.35-3woody2.

The unstable distribution (sid) does not contain exim-tls anymore.
The functionality has been incorporated in the main exim versions
which have these problems fixed in version 3.36-11 for exim 3 and in
version 4.33-1 for exim 4.

We recommend that you upgrade your exim-tls package.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20502-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 502-1 (exim-tls)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"exim-tls", ver:"3.35-3woody2", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
