# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 465-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53162);
 script_cve_id("CVE-2004-0079", "CVE-2004-0081");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 465-1 (openssl,openssl094,openssl095)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to openssl,openssl094,openssl095
announced via advisory DSA 465-1.

Two vulnerabilities were discovered in openssl, an implementation of
the SSL protocol, using the Codenomicon TLS Test Tool.  More
information can be found in the following NISCC Vulnerability
Advisory:

http://www.uniras.gov.uk/vuls/2004/224012/index.htm

and this OpenSSL advisory:

http://www.openssl.org/news/secadv_20040317.txt

- CVE-2004-0079 - null-pointer assignment in the
do_change_cipher_spec() function.  A remote attacker could perform
a carefully crafted SSL/TLS handshake against a server that used
the OpenSSL library in such a way as to cause OpenSSL to crash.
Depending on the application this could lead to a denial of
service.

- CVE-2004-0081 - a bug in older versions of OpenSSL 0.9.6 that
can lead to a Denial of Service attack (infinite loop).

For the stable distribution (woody) these problems have been fixed in
openssl version 0.9.6c-2.woody.6, openssl094 version 0.9.4-6.woody.4
and openssl095 version 0.9.5a-6.woody.5.

For the unstable distribution (sid) these problems will be fixed soon.

We recommend that you update your openssl package.



Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20465-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 465-1 (openssl,openssl094,openssl095)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"ssleay", ver:"0.9.6c-2.woody.6", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libssl-dev", ver:"0.9.6c-2.woody.6", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libssl0.9.6", ver:"0.9.6c-2.woody.6", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openssl", ver:"0.9.6c-2.woody.6", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libssl095a", ver:"0.9.5a-6.woody.5", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libssl09", ver:"0.9.4-6.woody.3", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
