# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 401-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53382);
 script_bugtraq_id(9005);
 script_cve_id("CVE-2003-0886");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 401-1 (hylafax)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to hylafax
announced via advisory DSA 401-1.

The SuSE Security Team discovered several exploitable formats string
vulnerabilities in hylafax, a flexible client/server fax system, which
could lead to executing arbitrary code as root on the fax server.

For the stable distribution (woody) this problem has been fixed in
version 4.1.1-1.3.

For the unstable distribution (sid) this problem has been fixed in
version 4.1.8-1.

We recommend that you upgrade your hylafax packages.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20401-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 401-1 (hylafax)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"hylafax-doc", ver:"4.1.1-3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"hylafax-client", ver:"4.1.1-3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"hylafax-server", ver:"4.1.1-3", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
