# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 393-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53677);
 script_cve_id("CVE-2003-0543", "CVE-2003-0544");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 393-1 (openssl)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to openssl
announced via advisory DSA 393-1.

Dr. Stephen Henson (steve@openssl.org), using a test suite provided by
NISCC (www.niscc.gov.uk), discovered a number of errors in the OpenSSL
ASN1 code.  Combined with an error that causes the OpenSSL code to parse
client certificates even when it should not, these errors can cause a
denial of service (DoS) condition on a system using the OpenSSL code,
depending on how that code is used. For example, even though apache-ssl
and ssh link to OpenSSL libraries, they should not be affected by this
vulnerability. However, other SSL-enabled applications may be
vulnerable and an OpenSSL upgrade is recommended.

For the current stable distribution (woody) these problems have been
fixed in version 0.9.6c-2.woody.4

For the unstable distribution (sid) these problems have been fixed in
version 0.9.7c-1

We recommend that you update your openssl package. Note that you will
need to restart services which use the libssl library for this update
to take effect.



Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20393-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 393-1 (openssl)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"ssleay", ver:"0.9.6c-2.woody.4", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libssl-dev", ver:"0.9.6c-2.woody.4", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libssl0.9.6", ver:"0.9.6c-2.woody.4", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openssl", ver:"0.9.6c-2.woody.4", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
