# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 329-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53618);
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 329-1 (osh)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to osh
announced via advisory DSA 329-1.

Steve Kemp discovered that osh, a shell intended to restrict the
actions of the user, contains two buffer overflows, in processing
environment variables and file redirections.  These vulnerabilities
could be used to execute arbitrary code, overriding any restrictions
placed on the shell.

For the stable distribution (woody) this problem has been fixed in
version 1.7-11woody1.

The old stable distribution (potato) is affected by this problem, and
may be fixed in a future advisory on a time-available basis.

For the unstable distribution (sid) this problem is fixed in version
1.7-12.

We recommend that you update your osh package.



Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20329-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 329-1 (osh)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"osh", ver:"1.7-11woody1", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
