# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 246-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53322);
 script_cve_id("CVE-2003-0042", "CVE-2003-0043", "CVE-2003-0044");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 246-1 (tomcat)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to tomcat
announced via advisory DSA 246-1.

The developers of tomcat discovered several problems in tomcat version
3.x.  The Common Vulnerabilities and Exposures project identifies the
following problems:

. CVE-2003-0042: A maliciously crafted request could return a
directory listing even when an index.html, index.jsp, or other
welcome file is present.  File contents can be returned as well.

. CVE-2003-0043: A malicious web application could read the contents
of some files outside the web application via its web.xml file in
spite of the presence of a security manager.  The content of files
that can be read as part of an XML document would be accessible.

. CVE-2003-0044: A cross-site scripting vulnerability was discovered
in the included sample web application that allows remote attackers
to execute arbitrary script code.

For the stable distribution (woody) this problem has been fixed in
version 3.3a-4.1.

The old stable distribution (potato) does not contain tomcat packages.

For the unstable distribution (sid) this problem has been fixed in
version 3.3.1a-1.

We recommend that you upgrade your tomcat package.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20246-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 246-1 (tomcat)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"tomcat", ver:"3.3a-4woody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libapache-mod-jk", ver:"3.3a-4woody1", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
