# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 218-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53740);
 script_bugtraq_id(6257);
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 218-1 (bugzilla)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to bugzilla
announced via advisory DSA 218-1.

A cross site scripting vulnerability has been reported for Bugzilla, a
web-based bug tracking system.  Bugzilla does not properly sanitize
any input submitted by users.  As a result, it is possible for a
remote attacker to create a malicious link containing script code
which will be executed in the browser of a legitimate user, in the
context of the website running Bugzilla.  This issue may be exploited
to steal cookie-based authentication credentials from legitimate users
of the website running the vulnerable software.

This vulnerability only affects users who have the 'quips' feature
enabled and who upgraded from version 2.10 which did not exist inside
of Debian.  The Debian package history of Bugzilla starts with 1.13
and jumped to 2.13.  However, users could have installed version 2.10
prior to the Debian package.

For the current stable distribution (woody) this problem has been
fixed in version 2.14.2-0woody3.

The old stable distribution (potato) does not contain a Bugzilla
package.

For the unstable distribution (sid) this problem will be fixed soon.

We recommend that you upgrade your bugzilla packages.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20218-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 218-1 (bugzilla)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"bugzilla-doc", ver:"2.14.2-0woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"bugzilla", ver:"2.14.2-0woody3", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
