# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1799-1 (qemu)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63995);
 script_cve_id("CVE-2008-0928", "CVE-2008-4539", "CVE-2008-1945");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 1799-1 (qemu)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to qemu
announced via advisory DSA 1799-1.

Several vulnerabilities have been discovered in the QEMU processor
emulator. The Common Vulnerabilities and Exposures project identifies the
following problems:

CVE-2008-0928

Ian Jackson discovered that range checks of file operations on
emulated disk devices were insufficiently enforced.

CVE-2008-1945

It was discovered that an error in the format auto detection of
removable media could lead to the disclosure of files in the
host system.

CVE-2008-4539

A buffer overflow has been found in the emulation of the Cirrus
graphics adaptor.


For the old stable distribution (etch), these problems have been fixed in
version 0.8.2-4etch3.

For the stable distribution (lenny), these problems have been fixed in
version 0.9.1-10lenny1.

For the unstable distribution (sid), these problems have been fixed in
version 0.9.1+svn20081101-1.

We recommend that you upgrade your qemu packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201799-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 1799-1 (qemu)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"qemu", ver:"0.8.2-4etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"qemu", ver:"0.9.1-10lenny1", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
