# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1727-1 (proftpd-dfsg)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63573);
 script_cve_id("CVE-2009-0542", "CVE-2009-0543");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 1727-1 (proftpd-dfsg)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to proftpd-dfsg
announced via advisory DSA 1727-1.

Two SQL injection vulnerabilities have been found in proftpd, a
virtual-hosting FTP daemon.  The Common Vulnerabilities and Exposures
project identifies the following problems:

CVE-2009-0542

Shino discovered that proftpd is prone to an SQL injection
vulnerability via the use of certain characters in the username.

CVE-2009-0543

TJ Saunders discovered that proftpd is prone to an SQL injection
vulnerability due to insufficient escaping mechanisms, when
multybite character encodings are used.

For the stable distribution (lenny), these problems have been fixed in
version 1.3.1-17lenny1.

For the oldstable distribution (etch), these problems will be fixed
soon.

For the testing distribution (squeeze), these problems will be fixed
soon.

For the unstable distribution (sid), these problems have been fixed in
version 1.3.2-1.

We recommend that you upgrade your proftpd-dfsg package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201727-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 1727-1 (proftpd-dfsg)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"proftpd-doc", ver:"1.3.1-17lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"proftpd", ver:"1.3.1-17lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"proftpd-basic", ver:"1.3.1-17lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"proftpd-mod-ldap", ver:"1.3.1-17lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"proftpd-mod-mysql", ver:"1.3.1-17lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"proftpd-mod-pgsql", ver:"1.3.1-17lenny1", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
