# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1662-1 (mysql-dfsg-5.0)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(61852);
 script_cve_id("CVE-2008-4098", "CVE-2008-4097");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 1662-1 (mysql-dfsg-5.0)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to mysql-dfsg-5.0
announced via advisory DSA 1662-1.

A symlink traversal vulnerability was discovered in MySQL, a
relational database server.  The weakness could permit an attacker
having both CREATE TABLE access to a database and the ability to
execute shell commands on the database server to bypass MySQL access
controls, enabling them to write to tables in databases to which they
would not ordinarily have access.

The Common Vulnerabilities and Exposures project identifies this
vulnerability as CVE-2008-4098.  Note that a closely aligned issue,
identified as CVE-2008-4097, was prevented by the update announced in
DSA-1608-1.  This new update supercedes that fix and mitigates both
potential attack vectors.

For the stable distribution (etch), this problem has been fixed in
version 5.0.32-7etch8.

We recommend that you upgrade your mysql packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201662-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 1662-1 (mysql-dfsg-5.0)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"mysql-server", ver:"5.0.32-7etch8", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mysql-common", ver:"5.0.32-7etch8", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mysql-client", ver:"5.0.32-7etch8", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mysql-client-5.0", ver:"5.0.32-7etch8", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mysql-server-5.0", ver:"5.0.32-7etch8", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmysqlclient15-dev", ver:"5.0.32-7etch8", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mysql-server-4.1", ver:"5.0.32-7etch8", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmysqlclient15off", ver:"5.0.32-7etch8", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
