# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1544-2 (pdns-recursor)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(61360);
 script_cve_id("CVE-2008-1637");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 1544-2 (pdns-recursor)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to pdns-recursor
announced via advisory DSA 1544-2.

Thomas Biege discovered that the upstream fix for the weak random number
generator released in DSA-1544-1 was incomplete:  Source port
randomization did still not use difficult-to-predict random numbers.
This is corrected in this security update.

Here is the text of the original advisory:

Amit Klein discovered that pdns-recursor, a caching DNS resolver, uses
a weak random number generator to create DNS transaction IDs and UDP
source port numbers. As a result, cache poisoning attacks were
simplified. (CVE-2008-1637)

In the light of recent DNS-related developments (documented in DSAs
1603, 1604, 1605), we recommend that this update is installed as an
additional safety measure.  (The lack of source port randomization was
addressed in the 3.1.6 upstream version.)

In addition, this update incorporates the changed IP address of
L.ROOT-SERVERS.NET.

For the stable distribution (etch), this problem has been fixed in
version 3.1.4-1+etch2.

For the unstable distribution (sid), this problem has been fixed in
version 3.1.7-1.

We recommend that you upgrade your pdns-recursor package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201544-2

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 1544-2 (pdns-recursor)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"pdns-recursor", ver:"3.1.4-1+etch2", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
